/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.Date;

/**
 * ジョブの待ち条件の判定対象に関する情報を保持するクラス<BR>
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobObjectInfo implements Serializable, Cloneable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = -4050301670424654620L;
	
	/** 判定対象種別 */
	protected int m_type;
	
	/** ジョブID */
	protected String m_jobId;
	
	/** ジョブ名 */
	protected String m_jobName;
	
	/** 値 */
	protected int m_value;
	
	/** 時刻 */
	protected Date m_time;
	
	/**
	 * 待ち条件の判定対象となるジョブIDを返す。<BR>
	 * @return 待ち条件の判定対象となるジョブID
	 */
	public String getJobId() {
		return m_jobId;
	}
	
	/**
	 * 待ち条件の判定対象となるジョブIDを設定する。<BR>
	 * @param jobId 待ち条件となる判定対象となるジョブID
	 */
	public void setJobId(String jobId) {
		this.m_jobId = jobId;
	}
	
	/**
	 * 待ち条件の時刻を返す。<BR>
	 * @return 待ち条件の時刻
	 */
	public Date getTime() {
		return m_time;
	}
	
	/**
	 * 待ち条件の時刻を設定する。<BR>
	 * @param time 待ち条件の時刻
	 */
	public void setTime(Date time) {
		this.m_time = time;
	}
	
	/**
	 * 待ち条件の判定対象となるジョブの値（終了値 or 終了状態）を返す。<BR>
	 * @return 待ち条件の判定対象となるジョブの値（終了値 or 終了状態）
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public int getValue() {
		return m_value;
	}
	
	/**
	 * 待ち条件の判定対象となるジョブの値（終了値 or 終了状態）を設定する。<BR>
	 * @param value 待ち条件の判定対象となるジョブの値（終了値 or 終了状態）
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setValue(int value) {
		this.m_value = value;
	}
	
	/**
	 * 判定対象種別を返す。<BR>
	 * @return 判定対象種別
	 * @see com.clustercontrol.bean.JudgmentObjectConstant
	 */
	public int getType() {
		return m_type;
	}
	
	/**
	 * 判定対象種別を設定する。<BR>
	 * @param type 判定対象種別
	 * @see com.clustercontrol.bean.JudgmentObjectConstant
	 */
	public void setType(int type) {
		this.m_type = type;
	}
	
	/**
	 * ジョブ名を返す。<BR>
	 * @return ジョブ名
	 */
	public String getJobName() {
		return m_jobName;
	}
	
	/**
	 * ジョブ名を設定する。<BR>
	 * @param jobName ジョブ名
	 */
	public void setJobName(String jobName) {
		this.m_jobName = jobName;
	}
	
	/**
	 * ジョブ判定対象情報のクローンを作成する。<BR>
	 * @return ジョブ判定対象情報のクローン
	 * @see java.lang.Object#clone()
	 */
	protected Object clone() {
		try {
			JobObjectInfo clone = (JobObjectInfo)super.clone();
			
			clone.setJobId(this.getJobId());
			clone.setJobName(this.getJobName());
			clone.setType(this.getType());
			clone.setValue(this.getValue());
			if(this.getTime() instanceof Date){
				clone.setTime((Date)this.getTime().clone());
			}
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}