/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.factory;

import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * メールテンプレート情報を削除するクラス<BR>
 *
 * @version 2.4.0
 * @since 2.4.0
 */
public class DeleteMailTemplate {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( DeleteMailTemplate.class );
	
	/**
	 * メールテンプレート情報を削除します。<BR>
	 * <p>
	 * <ol>
	 *  <li>メールテンプレートIDより、メールテンプレート情報を取得し、
	 *      メールテンプレート情報を削除します。</li>
	 * </ol>
	 * 
	 * @param mailTemplateId 削除対象のメールテンプレートID
	 * @return 削除に成功した場合、<code> true </code>
	 * @throws RemoveException
	 * @throws NamingException
	 */
	public boolean delete(String mailTemplateId) throws RemoveException, NamingException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.NOTIFY);
    	
		try {
			MailTemplateInfoUtil.getLocalHome().remove(mailTemplateId);
		} catch (EJBException e) {
			AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
			String[] args = { mailTemplateId };
			apllog.put("SYS", "003", args);
			m_log.warn("delete():" + e.getMessage());
			throw e;
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
			String[] args = { mailTemplateId };
			apllog.put("SYS", "003", args);
			m_log.warn("delete():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
			String[] args = { mailTemplateId };
			apllog.put("SYS", "003", args);
			m_log.warn("delete():" + e.getMessage());
			throw e;
		}
    	
    	return true;
	}
		
}
