/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.util;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EventConfirmConstant;
import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.ExecFacilityConstant;
import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.jobmanagement.bean.JobTriggerInfo;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerUtil;
import com.clustercontrol.notify.bean.QueueConstant;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;

/**
 * ジョブを呼出すクラス<BR>
 *
 * @version 3.0.0
 * @since 3.0.0
 */
public class RunJob extends InhibitAction{
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( RunJob.class );
	
    /** 実行失敗通知用Queue */
    private SendQueue m_queue;

    /**
     * ジョブ管理機能の指定されたジョブを呼出します。
     * <p>含まれているログ出力情報を基にジョブを呼出します。<BR>
     * ジョブの呼出に失敗した場合は、ログ出力情報の呼出失敗時の重要度で、監視管理機能のイベントへ通知します。
     * 
     * @param outputInfo　通知・抑制情報
     * @throws RemoteException 
     * @throws CreateException 
     * @throws NamingException 
     * @throws FinderException 
     * 
     * @see com.clustercontrol.jobmanagement.bean.JobTriggerInfo
     * @see com.clustercontrol.monitor.factory.OutputEventLog#insertEventLog(LogOutputInfo, int)
     */
    public synchronized void runJob(OutputNotifyGroupInfo outputInfo) throws RemoteException, NamingException, CreateException, FinderException {    	
		NotifyInfoLocal notifyInfo = NotifyInfoUtil.getLocalHome().findByPrimaryKey(outputInfo.getNotifyId());
		
    	NotifyJobInfoLocal jobInfo = NotifyJobInfoUtil.getLocalHome().findByPrimaryKey(
    			new NotifyJobInfoPK(outputInfo.getNotifyId(), outputInfo.getPriority()));
    	
    	if(jobInfo == null){
			m_log.debug("onMessage() : 出力する重要度が存在しません。");
			return;
    	}
    	
    	// 対象の重要度に通知フラグたっていた場合
    	if(jobInfo.getJobRun() == ValidConstant.TYPE_VALID) {
    		
			/*
			 * 実行するかどうかの判定
			 */
    		boolean isRun = false;
    		
    		// 抑制する場合（該当の重要度に抑制フラグがあり、抑制方法が「なし」以外の場合）
	    	if (jobInfo.getJobInhibitionFlg().intValue() == ValidConstant.TYPE_VALID &&
	    			notifyInfo.getInhibitionFlg().intValue() != ExclusionConstant.TYPE_NO){
	    		
				try {
					boolean isInhibit = super.isInhibit(outputInfo,	notifyInfo);
					
					// 抑制しない場合
					if(!isInhibit){
						isRun = true;
					}
					
				} catch (NumberFormatException e) {
					m_log.error("runJob() : " + e.getMessage(),e);
				} catch (RemoteException e) {
					m_log.error("runJob() : " + e.getMessage(),e);
				} catch (CreateException e) {
					m_log.error("runJob() : " + e.getMessage(),e);
				}	
	    	}
	    	// 抑制しない場合（上記以外）
	    	else{
	    		isRun = true;
	    	}
	    		
	    	
			/*
			 * 実行
			 */
	    	if(isRun){
	    		    		
				try {
					// 通知設定が「固定スコープ」となっていた場合は、ジョブに渡すファシリティIDを変更する
					if(jobInfo.getJobExecFacilityFlg() == ExecFacilityConstant.TYPE_FIX) {
						outputInfo.setFacilityId(jobInfo.getJobExecFacility());
					}

					// ジョブの実行契機を作成
					JobTriggerInfo triggerInfo = new JobTriggerInfo();
					triggerInfo.setTrigger_type(JobTriggerTypeConstant.TYPE_MONITOR);
					triggerInfo.setTrigger_info(outputInfo.getMonitorId()+"("+outputInfo.getPluginId()+")");	// 「監視項目ID(プラグインID)」形式で格納
					
					// ジョブ実行
					JobControllerLocal job = JobControllerUtil.getLocalHome().create();
					job.runJob(jobInfo.getJobId(), outputInfo, triggerInfo);

				}
				catch (Exception e) {
								
					//ジョブ失敗時の重要度を設定
					outputInfo.setPriority(jobInfo.getJobFailurePriority());
					outputInfo.setMessageId("200");	// FIXME メッセージIDを精査する
		            String[] args1 = { jobInfo.getJobId() };
					outputInfo.setMessage(Messages.getString("message.monitor.41", args1));
					outputInfo.setMessageOrg("");
					outputInfo.setOutputDate(new Timestamp(new Date().getTime()));
					outputInfo.setNotifyGroupId(null);	// 通知グループIDをリセットする
					
					try {
						
						m_queue = new SendQueue(QueueConstant.QUEUE_NAME_EVENT);
						m_queue.put(outputInfo);
						
					} catch (JMSException e1) {
						m_log.error(e1.getMessage(),e1);
					} finally {
						try {
							if(m_queue != null){
								m_queue.terminate();
							}
							m_queue = null;
						} catch (JMSException e1) {
							m_log.error(e1.getMessage(),e1);
						}
					}
					
//					OutputEvent event = new OutputEvent();
//					event.insertEventLog(outputInfo);
				}
	    	}
    	}
    }
}

