/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performance.composite.action.RealtimeSetGraphSelectionChangedListener;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.RealtimeCollectThread;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import com.clustercontrol.performance.view.action.RealtimeSetGraphAction;
import com.clustercontrol.performance.view.action.RealtimeSetGraphAction2;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.view.ScopeListBaseView;

/**
 * リアルタイムグラフ表示を行うViewクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class RealtimeGraphView extends ScopeListBaseView {

	public static final String ID = "com.clustercontrol.performance.view.RealtimeGraphView";

	private Composite parent;

	// 軸の変更などを可能とするためpublicにした.(暫定)
	public RealtimeGraphComposite graphComposite = null;

	//グラフ表示の基本情報(表示間隔など)を保持する領域を確保する。
	public RealtimeCollectorInfo collectorInfo;

	public RealtimeCollectorItemInfo collectorItemInfo;

	// staticでなければ、ダイアログ経由で停止することができない。
	static boolean isRequestCollectorToRun = false;

	public static RealtimeCollectThread collector = null;

	private boolean check = true;

	/**
	 *  リアルタイムグラフを描画します。
	 */
	public RealtimeGraphView() {
		// ノードを含め、INTERNAL, UNREGISTEREDを含めず, TOPICを受信するスコープツリーとする 
		super(false, false, false, true);
		initialize();
	}

	private void initialize() {
		//グラフ表示の基本情報(表示間隔など)を保持する領域を確保する。
		collectorInfo = new RealtimeCollectorInfo();
		//グラフ表示の表示データ基本情報(表示間隔など)を保持する領域を確保する。
		collectorItemInfo = new RealtimeCollectorItemInfo();
		// 初期値として現在時刻をセットしておく。(初回の収集用)

		// 初期値は0(auto)であるのでリアルタイムグラフ用の値をセット.
		// 12なら5秒間隔で1分間分を表示することを想定.(初期開発の仕様に準じた)
		collectorInfo.setGraphPlotNum(12);

		//初期値のセット
		//初期表示でグラフを非表示にするなら、ダイアログ画面での初期状態も
		//全項目非表示とすべき。

		// 動的に項目を設定する場合には、この方式は対応しきれない.
		// 位置情報itemIdがNULLのときは初期状態と判定し、値がセットされているときは前回設定があると判定する.
		// FIXME DBのマスタ情報が"CPU0100_CPU_UTIL"ではなくなった場合エラーとなる
		collectorItemInfo.setItemInfo(0, "CPU0100_CPU_UTIL", "NonDisplay",	"", true); // CPU(CODE_CPU_UTILIZATION)
		collectorItemInfo.setItemInfo(1, "CPU0100_CPU_UTIL", "NonDisplay",	"", true); // CPU(CODE_CPU_UTILIZATION)
		collectorItemInfo.setItemInfo(2, "CPU0100_CPU_UTIL", "NonDisplay",	"", true); // CPU(CODE_CPU_UTILIZATION)
		collectorItemInfo.setItemInfo(3, "CPU0100_CPU_UTIL", "NonDisplay",	"", true); // CPU(CODE_CPU_UTILIZATION)

		String itemCodeList[] = CollectorItemCodeFactory.getCodeAll();
		int itemCodeNum = 0;

		for (int i = 0; i < itemCodeList.length; i++) {
			// 最初からデバイス別でないitemCodeの数が分れば嬉しいのだけれど.
			if (!CollectorItemCodeFactory.isDeviceSupport(itemCodeList[i])) {
				itemCodeNum = itemCodeNum + 1;
			}
		}

		int j = 0;
		collectorItemInfo.createItemInfoForCollector(itemCodeNum);
		for (int i = 0; i < itemCodeList.length; i++) {
			// 最初からデバイス別でないitemCodeの数が分れば嬉しいのだけれど.
			if (!CollectorItemCodeFactory.isDeviceSupport(itemCodeList[i])) {
				boolean isDetailed = true;
				List factorySubItemCodeList = CollectorItemCodeFactory
						.getSubItemCode(itemCodeList[i]);
				if (factorySubItemCodeList == null
						|| factorySubItemCodeList.size() == 0) { // 子項目が存在しない項目の場合.deviceindex=0
					isDetailed = false;
				}
				// 右の値はダミー値 : index=0, itemId=0, deviceName=dummy.
				collectorItemInfo.setItemInfoForCollector(j, itemCodeList[i], null, isDetailed);
				j = j + 1;
			}
		} // for
	}

	/**
	 * extendのScopeListBaseViewへの変更による追加(自動生成)。
	 * ツリーペインでスコープを選択すると呼び出される。
	 *
	 * @param parent
	 *            スコープツリーアイテム
	 */
	// ビュー起動時にもここが実行される。スコープツリーを表示しているため。    
	protected Composite createListContents(Composite parent) {
		//スコープ選択時にgraphCompositeをnewするために保持する。
		this.parent = parent;

		GridLayout layout = new GridLayout(1, true);
		this.parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		//ボタン（アクション）を制御するリスナーを登録
		super.getScopeTreeComposite().getTreeViewer()
				.addSelectionChangedListener(
						new RealtimeSetGraphSelectionChangedListener());

		this.update();

		//初期表示グラフを表示すべきか。
		//   この点、グラフ表示条件の選択がされていないことを明示する
		//   するため、空のグラフは表示しない。
		return this.graphComposite;
	}

	/**
	 * 選択されたスコープ(ノード)の情報を表示します。
	 * 
	 * @param item
	 *            スコープツリーアイテム
	 */
	protected void doSelectTreeItem(FacilityTreeItem item) {

		if (item.getData().getFacilityId() == null
				|| "".equals(item.getData().getFacilityId())) {
			// 何もしない。(引数チェック)
		} else if (collectorInfo.getFacilityId() != null
				&& collectorInfo.getFacilityId().equals(
						item.getData().getFacilityId())) {
			// 何もしない。(連打への対処)
		} else {
			//選択されたスコープ情報をグラフ基本情報に書き込む。
			collectorInfo.setFacilityId(item.getData().getFacilityId());
			collectorInfo.setSubScopeNum(item.getChildren().length);

			List itemList = CollectorItemCodeFactory
					.getAvailableCollectorItemList(item.getData()
							.getFacilityId());

			if (itemList != null) {

				// 表示項目撰択のリストの作成.
				// スコープを切り替えると再作成される.つまり、deviceIndex毎の表示は保持されない.
				collectorItemInfo.createItemInfoForCollector(itemList.size());

				for (int i = 0; i < itemList.size(); i++) {
					CollectorItemInfo itemInfo = (CollectorItemInfo) itemList
							.get(i);

					// スコープ詳細表示可能であるか否かをチェックする.
					boolean isDetailed = true;
					List factorySubItemCodeList = CollectorItemCodeFactory
							.getSubItemCode(itemInfo.getItemCode());
					if (factorySubItemCodeList == null
							|| factorySubItemCodeList.size() == 0) { // 子項目が存在しない項目の場合.
						isDetailed = false;
					}

					
					
					collectorItemInfo.setItemInfoForCollector(
							i, 
							itemInfo.getItemCode(), 
							itemInfo.getDeviceName(),
							isDetailed);
				}
			}

			// グラフ表示項目の指定変更(既に指定されたdeviceIndex(itemId)が存在しない場合への対処)
			loop1: for (int i = 0; i < collectorInfo.getGraphNum(); i++) {
				if (collectorItemInfo.getDeviceName(i) != null) {
					boolean found = false;
					loop2: for (int j = 0; j < collectorItemInfo
							.getItemNumForCollector(); j++) {
						if (collectorItemInfo.getItemCode(i).equals(
								collectorItemInfo.getItemCodeForCollector(j))
								&& collectorItemInfo.getDeviceName(i).equals(
										collectorItemInfo.getDeviceNameForCollector(j))) {
							found = true;
							if (!collectorItemInfo.hasDevice(i)) {
								collectorItemInfo.setHasDevice(i, true);
							}
							break loop2;
						}
					} // loop2
					if (!found) {
						collectorItemInfo.setHasDevice(i, false);
					}

				}
			} // loop1

			//選択されたスコープのサブスコープ情報をグラフ基本情報に書き込む。
			//データに直接アクセスできず、リストでしか取得できないので一旦保持する。
			FacilityTreeItem[] childrenList = item.getChildren();

			// ファシリティID順に並び替える
			Arrays.sort(childrenList, new Comparator() {
				public int compare(Object o1, Object o2) {
					if (o1 instanceof FacilityTreeItem
							&& o2 instanceof FacilityTreeItem) {
						String object1 = ((FacilityTreeItem) o1).getData()
								.getFacilityId();
						String object2 = ((FacilityTreeItem) o2).getData()
								.getFacilityId();

						return object1.compareTo(object2);
					}
					return 0;
				}
			});

			if (item.getChildren().length > 0) {
				ArrayList subScopeFacilityId = new ArrayList();
				ArrayList subScopeFacilityName = new ArrayList();

				for (int i = 0; i < childrenList.length; i++) {
					subScopeFacilityId.add(childrenList[i].getData()
							.getFacilityId());
					subScopeFacilityName.add(childrenList[i].getData()
							.getFacilityName());
				}
				collectorInfo.setSubScopeFacilityId(subScopeFacilityId);
				collectorInfo.setSubScopeFacilityName(subScopeFacilityName);
			}
			this.update();
		}
	}

	/**
	 * ビューを更新します。
	 */
	public synchronized void update() {
		// 直列化することにより、連打対策をとる.連打対策などの交通整理は総てここで行なう.
		// ここがThreadで呼ばれなければsyncronizedの意味なし.
		Date timestamp = new Date(System.currentTimeMillis());
		// timestamp値をセットしたら、値(-1=NG,0=initial,0<=連打)を返却する。
		int timestampId = collectorInfo.setCurrentCollect(timestamp);
		prepareToUpdate(timestamp, timestampId);
	}

	/**
	 * 指定の
	 * @param timestamp
	 * @param timestampId
	 */
	private void prepareToUpdate(Date timestamp, int timestampId) {
		// 念のためチェック.
		if (collectorInfo.isCurrentCollect(timestamp, timestampId)) {
			graphUpdate(timestamp, timestampId);
		}
	}

	/**
	 * グラフを更新します。
	 */
	private void graphUpdate(Date timestamp, int timestampId) {
		//グラフ表示
		//   初期表示の場合はスコープ選択しても何も表示しない。
		//   (グラフ表示条件未指定であることをわかりやすくする)
		int interval = collectorInfo.getInterval();
		// マネージャへのデータ要求をするか否かの判定を初期化する。
		isRequestCollectorToRun = false;

		// intervalは初期状態のみゼロとなる。
		if (interval != 0 && (collectorInfo.getFacilityId() != null)) {

			boolean isXRangeAuto = false;
			if (collectorInfo.getGraphPlotNum() == 0) {
				isXRangeAuto = true;
			}

			// グラフそれぞれのcopmositeを消す(nullpointerエラーとなる)のではなく、baseCompositeを消す。
			// この場合、再度baseGridDataを作成しなおさねばならない。parentのlayoutは再セット不要。
			// 次の仕様改善では、baseCompositeをそのままで各グラフを再作成するような仕様に変更する.
			if (graphComposite != null) {
				graphComposite.dispose();
			}

			graphComposite = new RealtimeGraphComposite(this.parent, SWT.NONE);
			graphComposite.setCollectorInfo(collectorInfo);
			graphComposite.setCollectorItemInfo(collectorItemInfo);

			GridData baseGridData = new GridData();
			baseGridData.horizontalAlignment = GridData.FILL;
			baseGridData.verticalAlignment = GridData.FILL;
			baseGridData.grabExcessHorizontalSpace = true;
			baseGridData.grabExcessVerticalSpace = true;
			graphComposite.setLayoutData(baseGridData);

			GridLayout baseLayout = new GridLayout(1, true);
			graphComposite.setLayout(baseLayout);
			baseLayout.marginHeight = 0;
			baseLayout.marginWidth = 0;

			/*
			 * ここからがグラフ描画の処理
			 */
			int graphNum = collectorInfo.getGraphNum();
			String facilityId = collectorInfo.getFacilityId();

			for (int i = 0; i < graphNum; i++) {
				String itemCode = collectorItemInfo.getItemCode(i);
				String deviceName = collectorItemInfo.getDeviceName(i); //  .getDeviceNameForCollector(Integer.valueOf(collectorItemInfo.getItemId(i)));
				String displayType = collectorItemInfo.getDisplayType(i);
				int graphPlotNum = collectorInfo.getGraphPlotNum();

				graphComposite.addGraph(i, //graphId,
						itemCode, deviceName, collectorInfo.getSubScopeNum(),
						displayType, interval, isXRangeAuto, graphPlotNum); // isXRangeAutoはとりあえずfalseの仕様とする.

				collectorItemInfo.setIsCollect(i, graphComposite.isCollect());

				if (graphComposite.isCollect()) {
					setCollector(timestamp, timestampId, itemCode,
							deviceName, displayType, interval,
							facilityId);
				}
			}

			// ここは、以下の2つのチェックを経ている。
			//   (1) ダイアログでのグラフ表示の有無の判定。 
			//   (2) サブスコープ表示でノードを選択した場合のグラフ表示の有無の判定。
			if (!isRequestCollectorToRun) {
				try {
					// セッションを切断
				} catch (Exception e) {
					// まだ収集を開始していない場合はそのまま処理を先に進める。
				}
			}

			//ScopeListBaseViewのパッチを適用することにより解決せず。このロジックを削除したいが残す。
			// うまく再描画されないので、Sash変更で応急対処。
			SashForm treeSash = this.getTreeSash();
			treeSash.setWeights(new int[] { 29, 71 });
			treeSash.setWeights(new int[] { 30, 70 });
		}
	}

	private void setCollector(Date timestamp, int collectTimestampId,
			String itemCode, String deviceName,
			String displayType, int interval, String facilityId) {
		int requestInterval = collectorInfo.getRequestInterval();

		if (graphComposite.m_timeseries == null) {
		}
		// Threadインスタンスの生成(Threadの実行はまだ)
		collector = new RealtimeCollectThread(timestamp, collectTimestampId,
				graphComposite.m_timeseries, itemCode,
				deviceName, displayType, interval, requestInterval, facilityId,
				check, graphComposite); // 軸の変更対象を伝えるため.

		collector.setCollectorInfo(collectorInfo);
		// Thread起動のメソッド.実際にはオーバライドされたrun()が実行される.
		collector.start();

		// ここでThreadの生成をしているなら、停止も直接管理できる(notify,etc).
		// たたこの場合はwait setに一旦入れる必要があるのであまり関係ない??
		// タイムスタンプ情報はcollectorInfoで管理すればstaticにしなくてもThreadから参照できる.
	}

	/**
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
		// セッションを切断
		// 何もグラフ表示せずそのまま画面を閉じる場合や、グラフ表示できなかった場合のハンドリングが必要。
		try {
			// セッションを切断
			//			clientRealTimeController.setRunning(false);
			// 既に収集中の処理が停止するようにタイムスタンプを更新する。
			//			RealtimeController.setCollectTimestamp();
		} catch (Exception e) {
			// まだ収集を開始していない場合はそのまま処理を先に進める。
		}

		super.dispose();
	}

	/**
	 * ビューのアクションの有効/無効を設定
	 * 
	 * @param type 選択種別
	 * @param selection ボタン（アクション）を有効にするための情報 
	 * @since 1.0
	 */
	public void setEnabledAction(int type, ISelection selection) {
		// ビューアクションの使用可/不可を設定
		super.setEnabledAction(RealtimeSetGraphAction.ID, selection);
		super.setEnabledAction(RealtimeSetGraphAction2.ID, selection);

		// 初期値を設定    	
		super.setEnabledAction(RealtimeSetGraphAction.ID, false);
		super.setEnabledAction(RealtimeSetGraphAction2.ID, false);

		if (type == FacilityConstant.TYPE_COMPOSITE) {
			// Ver2.2時点では未実装
		} else if (type == FacilityConstant.TYPE_SCOPE) {
			super.setEnabledAction(RealtimeSetGraphAction.ID, true);
			super.setEnabledAction(RealtimeSetGraphAction2.ID, true);
		} else if (type == FacilityConstant.TYPE_NODE) {
			super.setEnabledAction(RealtimeSetGraphAction.ID, true);
			super.setEnabledAction(RealtimeSetGraphAction2.ID, true);
		}
	}
}