/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.bean;

/**
 * 収集の動作状態を保持するクラス
 * 状態として、正常(NORMAL)、警告(WARNING)、エラー(ERROR)の3種類のいずれかを定義します。
 * 
 * @version 1.0
 * @since 1.0
 */
public final class CollectorState implements java.io.Serializable {
	public final static int NORMAL = 1;
	public final static int WARNING = 2;
	public final static int ERROR = 3;
	
	private int state;
	private String errorCode;
	private String message;
	
	/**
	 * コンストラクタ
	 * 動作状態は"正常"でインスタンスが作成されます。
	 */
	public CollectorState(){
		this.state = NORMAL;
	}

	/**
	 * コンストラクタ
	 * 動作状態を指定してインスタンスを作成します。
	 */
	public CollectorState(int state){
		this.state = state;
	}

	/**
	 * コンストラクタ
	 * 動作状態とメッセージを指定してインスタンスを作成します。
	 */
	public CollectorState(int state, String message){
		this.state = state;
		this.message = message;
	}
	
	/**
	 * エラーコードを取得します。
	 * 
	 * @return errorCode を戻します。
	 */
	public String getErrorCode() {
		return errorCode;
	}

	/**
	 * 動作状態に"正常"を設定します。
	 */
	public void setNormal() {
		this.errorCode = null;
		this.state = NORMAL;
	}

	/**
	 * 動作状態に"警告"を設定します。
	 * @param errorCode エラーコード
	 */
	public void setWarning(String errorCode) {
		this.errorCode = errorCode;
		this.state = WARNING;
	}
	
	/**
	 * 動作状態に"エラー"を設定します。
	 * @param errorCode エラーコード
	 */
	public void setError(String errorCode) {
		this.errorCode = errorCode;
		this.state = ERROR;
	}
	
	/**
	 * メッセージを取得します。
	 * @return message を戻します。
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * メッセージを設定します。
	 * 
	 * @param message message を設定。
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * メッセージを追記します。
	 * 
	 * @param message message を設定。
	 */
	public void addMessage(String message) {
		this.message = this.message + message;
	}
}
