/*
                                                                                                                                                                 
Copyright (C) 2008 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.util;

import java.util.HashMap;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstUtil;
import com.clustercontrol.performance.operator.Operator;
import com.clustercontrol.performance.operator.Undefined;
import com.clustercontrol.sharedtable.DataTable;

/**
 *SNMPで取得した値からグラフに必要な値への計算を行うクラス
 *
 * 
 * @version 1.0
 * @since 1.0
 */

public final class CalculationMethod {
	private static Log m_log = LogFactory.getLog( CalculationMethod.class );
	
	private static Object modifyLock = new Object();
		
	private static final String DEFAULT_METHOD_CLASS_PACKAGE = "com.clustercontrol.performance.operator";
	
	private static HashMap<CollectorItemCalcMethodMstPK, Operator> m_operationMap = 
		new HashMap<CollectorItemCalcMethodMstPK, Operator>();
	
	public static double getPerformance(
			final String platformId, 
			final CollectorItemInfo itemInfo, 
			final CollectorDeviceInfoData deviceData,
			final DataTable currentTable,
			final DataTable previousTable){
		// 計算方法を特定するためのキーを生成
		CollectorItemCalcMethodMstPK pk = 
			new CollectorItemCalcMethodMstPK(
					itemInfo.getCollectMethod(), 
					platformId,
					itemInfo.getItemCode());

		// 計算方法を取得
		try {
			Operator ope = m_operationMap.get(pk);

			// 登録されていない場合は登録
			if (ope == null){
				registerOperation(pk);

				ope = m_operationMap.get(pk);

				// 登録できなかった場合
				if(ope == null){
					return Double.NaN;
				}
			}

			// データテーブルをセットして計算
			// Operationクラスは共有されるため排他制御が必要
			synchronized (ope) {
				ope.setCurrentTable(currentTable);
				ope.setPreviousTable(previousTable);
				// デバイス情報が必要な場合
				if(deviceData == null || deviceData.getIndex() == -1){
					// デバイス情報を保持していない
					// インデックスとしては取りえない値（-1）を設定
					ope.setDeviceIndex(-1);
				} else {
					ope.setDeviceIndex(deviceData.getIndex());
				}
				
				return ope.calc();
			}
		} catch (Exception e){
			m_log.debug(e.getMessage(), e);
			// 例外発生時はNaNを返す
			return Double.NaN;
		}
	}
	
	private static void registerOperation(CollectorItemCalcMethodMstPK pk){
		synchronized (modifyLock) {
			try {
				m_log.debug("Register Operation : "
						+ pk.getItemCode() + ", "
						+ pk.getPlatformId() + ", "
						+ pk.getCollectMethod());
				CollectorItemCalcMethodMstLocal bean = 
					CollectorItemCalcMethodMstUtil.getLocalHome().findByPrimaryKey(pk);

				String calcMethod = bean.getCalcMethod();

				CollectorCalcMethodMstLocal methodMst = 
					CollectorCalcMethodMstUtil.getLocalHome().findByPrimaryKey(calcMethod);

				try {
					String className = methodMst.getClassName();
					
					// 指定されているクラス名に"."を含まない場合
					if(className.indexOf('.') == -1){
						// デフォルトのパッケージ名を補完
						className = DEFAULT_METHOD_CLASS_PACKAGE + "." + className;
					}
					
					Operator ope = (Operator)Class.forName(className).newInstance();
					// 初期化
					ope.setPlatformId(bean.getPlatformId());
					ope.setItemCode(bean.getItemCode());
					
					m_operationMap.put(pk, ope);
				} catch (ClassNotFoundException e) {
					m_log.error(e.getMessage(), e);
				} catch (InstantiationException e) {
					m_log.error(e.getMessage(), e);
				} catch (IllegalAccessException e) {
					m_log.error(e.getMessage(), e);
				}
			} catch (FinderException e) {
				// 指定の収集コードに対応する計算方法がDBに登録されていない場合、
				// 必ずDouble.NaNを返すクラスを登録する
				m_log.error("No such entity!  "
						+ pk.getItemCode() + ", "
						+ pk.getPlatformId() + ", "
						+ pk.getCollectMethod());
				m_operationMap.put(pk, new Undefined());
				m_log.debug(e.getMessage(), e);
			} catch (NamingException e) {
				m_log.error(e.getMessage(), e);
			}
		}
	}
}
