/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.repository.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ノードの追加を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 1.0.0
 */
public class AddNodeProperty {

    // ----- instance メソッド ----- //

    /**
     * 指定したノードを追加します。
     * 
     * @param property
     *            属性情報
     * @return 登録に成功した場合、true
     */
    public boolean add(Property property) {
    	Property copy = PropertyUtil.copy(property);
        PropertyUtil.deletePropertyDefine(copy);

        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();
        
        boolean result = false;
        try {
            repository.addNode(copy);
            result = true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
	            
			} else if (e.getCause() instanceof EJBException) {
				MessageDialog.openError(null, Messages.getString("failed"),  Messages.getString("message.repository.5") + "\n\n--\n" + e.getMessage());
				return result;
			}
        } catch (NamingException e) {
        } catch (FinderException e) {
        } catch (CreateException e) {
			if(e instanceof DuplicateKeyException){
				// ファシリティIDが重複している場合、エラーダイアログを表示する
				
				//ファシリティID取得
		        ArrayList values = PropertyUtil.getPropertyValue(copy, NodeProperty.FACILITY_ID);
				String args[] = { (String)values.get(0) };

	            MessageDialog.openInformation(
	            		null, 
	            		Messages.getString("message"),
	                    Messages.getString("message.repository.26", args));
	            return result;
			}
        }
        
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.repository.4"));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.repository.5"));
		}
    	
    	return result;
    }
}