/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.poller.snmp;

import java.io.Serializable;
import java.net.InetAddress;

/**
 * SNMPのポーリングに必要な設定情報を保持するクラス
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
public class SnmpConfig implements Serializable {
	private static final long serialVersionUID = 7066324339063820651L;

	private InetAddress address;
	private int port = -1;
	private int version = 1;
	private String comunity = "public";
	private int retries = -1;
	private int timeout = 1000;
	
	/**
	 *  コンストラクタ
	 * @param address IPアドレス
	 */
	public SnmpConfig(InetAddress address){
		this.address = address;
	}

	/**
	 * IPアドレスを返します。
	 * @return IPアドレス
	 */
	public InetAddress getAddress() {
		return address;
	}

	/**
	 * IPアドレスを設定します。
	 * @param address IPアドレス
	 */
	public void setAddress(InetAddress address) {
		this.address = address;
	}

	/**
	 * コミュニティ名を返します。
	 * @return コミュニティ名
	 */
	public String getComunity() {
		return comunity;
	}

	/**
	 * コミュニティ名を設定します。
	 * @param comunity コミュニティ名
	 */
	public void setComunity(String comunity) {
		this.comunity = comunity;
	}

	/**
	 * ポート番号を返します。
	 * @return ポート番号
	 */
	public int getPort() {
		return port;
	}

	/**
	 * ポート番号を設定します。
	 * @param port ポート番号
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * リトライ回数を返します。
	 * @return リトライ回数
	 */
	public int getRetries() {
		return retries;
	}

	/**
	 * リトライ回数を設定します。
	 * @param retries リトライ回数
	 */
	public void setRetries(int retries) {
		this.retries = retries;
	}

	/**
	 * タイムアウト時間を返します。
	 * @return タイムアウト時間
	 */
	public int getTimeout() {
		return timeout;
	}

	/**
	 * タイムアウト時間を設定します。
	 * @param timeout タイムアウト時間
	 */
	public void setTimeout(int timeout) {
		this.timeout = timeout;
	}

	/**
	 * SNMPのバージョンを返します。
	 * @return SNMPのバージョン
	 */
	public int getVersion() {
		return version;
	}

	/**
	 * SNMPのバージョンを設定します。
	 * @param version SNMPのバージョン 
	 */
	public void setVersion(int version) {
		this.version = version;
	}
}
