/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;

import java.util.ArrayList;

import com.clustercontrol.util.Messages;


/**
 * ジョブのジョブ変数におけるシステム変数に関する情報を定義するクラス<BR>
 * 
 * @version 4.0.0
 * @since 2.1.0
 */
public class SystemParameterConstant {
	/** 呼び出し元のアプリケーション */
	public static final String APPLICATION = "APPLICATION";
	/** 呼び出し元のファシリティID */
	public static final String FACILITY_ID = "FACILITY_ID";
	/** ファイル名(実行契機がファイルチェックのときに値が入る) */
	public static final String FILENAME = "FILENAME";
	/** 呼び出し元のメッセージ */
	public static final String MESSAGE = "MESSAGE";
	/** 呼び出し元のメッセージID */
	public static final String MESSAGE_ID = "MESSAGE_ID";
	/** 呼び出し元の監視項目ID */
	public static final String MONITOR_ID = "MONITOR_ID";
	/** 呼び出し元のオリジナルメッセージ */
	public static final String ORG_MESSAGE = "ORG_MESSAGE";
	/** 呼び出し元のプラグインID */
	public static final String PLUGIN_ID = "PLUGIN_ID";
	/** 呼び出し元の重要度 */
	public static final String PRIORITY = "PRIORITY";
	/** ジョブセッションID */
	public static final String SESSION_ID = "SESSION_ID";
	/** ジョブセッション開始日時 */
	public static final String START_DATE = "START_DATE";
	/** ジョブ起動種類*/
	public static final String TRIGGER_INFO = "TRIGGER_INFO";
	/** ジョブ起動契機 */
	public static final String TRIGGER_TYPE = "TRIGGER_TYPE";


	/** ジョブ変数 ヘッダー */
	private static final String PREFIX = "#[";
	/** ジョブ変数 フッター */
	private static final String SUFFIX = "]";

	public static final ArrayList<ArrayList<String>> ALL =
			new ArrayList<ArrayList<String>>() {{
				add(new ArrayList<String>() {{
					add(APPLICATION);add(Messages.getString("application"));}});
				add(new ArrayList<String>() {{
					add(FACILITY_ID);add(Messages.getString("facility.id"));}});
				add(new ArrayList<String>() {{
					add(FILENAME);add(Messages.getString("file.name"));}});
				add(new ArrayList<String>() {{
					add(MESSAGE);add(Messages.getString("message"));}});
				add(new ArrayList<String>() {{
					add(MESSAGE_ID);add(Messages.getString("message.id"));}});
				add(new ArrayList<String>() {{
					add(MONITOR_ID);add(Messages.getString("monitor.id"));}});
				add(new ArrayList<String>() {{
					add(ORG_MESSAGE);add(Messages.getString("message.org"));}});
				add(new ArrayList<String>() {{
					add(PLUGIN_ID);add(Messages.getString("plugin.id"));}});
				add(new ArrayList<String>() {{
					add(PRIORITY);add(Messages.getString("priority"));}});
				add(new ArrayList<String>() {{
					add(SESSION_ID);add(Messages.getString("session.id"));}});
				add(new ArrayList<String>() {{
					add(START_DATE);add(Messages.getString("start.time"));}});
				add(new ArrayList<String>() {{
					add(TRIGGER_INFO);add(Messages.getString("trigger.info"));}});
				add(new ArrayList<String>() {{
					add(TRIGGER_TYPE);add(Messages.getString("trigger.type"));}});
			}};

			public static final Object SYSTEM_ID_LIST[] = {
				SystemParameterConstant.APPLICATION,
				SystemParameterConstant.FACILITY_ID,
				SystemParameterConstant.FILENAME,
				SystemParameterConstant.MESSAGE,
				SystemParameterConstant.MESSAGE_ID,
				SystemParameterConstant.MONITOR_ID,
				SystemParameterConstant.ORG_MESSAGE,
				SystemParameterConstant.PLUGIN_ID,
				SystemParameterConstant.PRIORITY,
				SystemParameterConstant.SESSION_ID,
				SystemParameterConstant.START_DATE,
				SystemParameterConstant.TRIGGER_INFO,
				SystemParameterConstant.TRIGGER_TYPE
			};

			/**
			 * strが#[param]の形式であるかを判定する
			 * 
			 * @param str
			 * @param param
			 * @return
			 */
			public static boolean isParam(String str, String param){
				if(param == null || param == null){
					return false;
				}
				if(str.equals(getParamText(param))){
					return true;
				}
				else{
					return false;
				}
			}

			/**
			 * ジョブ変数をパラメータ形式で返却する
			 * 
			 * @param param
			 * @return
			 */
			public static String getParamText(String param){
				return PREFIX + param + SUFFIX;
			}
}