/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.util;

import java.util.ArrayList;
import java.util.HashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.PropertyDefine;

/**
 * プロパティユーティリティクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class PropertyUtil {
	protected static Log m_log = LogFactory.getLog(PropertyUtil.class);

	/**
	 * プロパティ値の取得
	 * 
	 * @param property
	 * @param id
	 * @return プロパティの配列
	 */
	public static ArrayList getPropertyValue(Property property, String id) {
		ArrayList list = new ArrayList();

		getPropertyValue(property, id, list);

		return list;
	}

	/**
	 * プロパティ値の取得（再帰呼び出し）
	 * 
	 * @param property
	 * @param id
	 * @param list
	 */
	public static void getPropertyValue(Property property, String id,
			ArrayList list) {

		//IDが一致するプロパティをリストに追加
		if (id != null && property.getID() != null) {
			if (id.compareTo(property.getID()) == 0) {
				list.add(property.getValue());
			}
		}

		//子プロパティを検索する
		if (property.getEditor() instanceof String
				&& property.getEditor().compareTo(
						PropertyConstant.EDITOR_SELECT) == 0) {
			Object[][] value = property.getSelectValues();
			for (int j = 0; j < value[PropertyConstant.SELECT_VALUE].length; j++) {
				if (value[PropertyConstant.SELECT_VALUE][j] instanceof HashMap) {
					HashMap map = (HashMap) value[PropertyConstant.SELECT_VALUE][j];

					//子Propertyを取得
					ArrayList propertyList = (ArrayList) map
					.get(PropertyConstant.MAP_PROPERTY);
					if (propertyList instanceof ArrayList) {
						for (int k = 0; k < propertyList.size(); k++) {
							Property children2 = (Property) propertyList.get(k);
							getPropertyValue(children2, id, list);
						}
					}
				}
			}
		} else {
			//子Propertyを取得
			Object[] childrens = property.getChildren();

			for (int i = 0; i < childrens.length; i++) {
				Property children1 = (Property) childrens[i];
				getPropertyValue(children1, id, list);
			}
		}
	}

	/**
	 * プロパティの取得
	 * 
	 * @param property
	 * @param id
	 * @return プロパティの配列
	 */
	public static ArrayList getProperty(Property property, String id) {
		ArrayList list = new ArrayList();

		getProperty(property, id, list);

		return list;
	}

	/**
	 * プロパティの取得（再帰呼び出し）
	 * 
	 * @param property
	 * @param id
	 * @param list
	 */
	public static void getProperty(Property property, String id, ArrayList list) {
		//IDが一致するプロパティをリストに追加
		if (id != null && property.getID() != null) {
			if (id.compareTo(property.getID()) == 0) {
				list.add(property);
			}
		}

		//子プロパティを検索する
		if (property.getEditor() instanceof String
				&& property.getEditor().compareTo(
						PropertyConstant.EDITOR_SELECT) == 0) {
			Object[][] value = property.getSelectValues();
			for (int j = 0; j < value[PropertyConstant.SELECT_VALUE].length; j++) {
				if (value[PropertyConstant.SELECT_VALUE][j] instanceof HashMap) {
					HashMap map = (HashMap) value[PropertyConstant.SELECT_VALUE][j];

					//子Propertyを取得
					ArrayList propertyList = (ArrayList) map
					.get(PropertyConstant.MAP_PROPERTY);
					if (propertyList instanceof ArrayList) {
						for (int k = 0; k < propertyList.size(); k++) {
							Property children2 = (Property) propertyList.get(k);
							getProperty(children2, id, list);
						}
					}
				}
			}
		} else {
			//子Propertyを取得
			Object[] childrens = property.getChildren();

			for (int i = 0; i < childrens.length; i++) {
				Property children1 = (Property) childrens[i];
				getProperty(children1, id, list);
			}
		}
	}

	/**
	 * プロパティの取得（再帰呼び出し）
	 * 
	 * @param property
	 */
	public static void deletePropertyDefine(Property property) {

		//子プロパティを検索する
		if (property.getEditor() instanceof String
				&& property.getEditor().compareTo(
						PropertyConstant.EDITOR_SELECT) == 0) {
			Object[][] value = property.getSelectValues();
			for (int j = 0; j < value[PropertyConstant.SELECT_VALUE].length; j++) {
				if (value[PropertyConstant.SELECT_VALUE][j] instanceof HashMap) {
					HashMap map = (HashMap) value[PropertyConstant.SELECT_VALUE][j];

					//子Propertyを取得
					ArrayList propertyList = (ArrayList) map
					.get(PropertyConstant.MAP_PROPERTY);
					if (propertyList instanceof ArrayList) {
						for (int k = 0; k < propertyList.size(); k++) {
							Property children2 = (Property) propertyList.get(k);
							deletePropertyDefine(children2);
						}
					}
				}
			}
		} else {
			//子Propertyを取得
			Object[] childrens = property.getChildren();

			for (int i = 0; i < childrens.length; i++) {
				Property children1 = (Property) childrens[i];
				deletePropertyDefine(children1);
			}
		}

		//PropertyDefineを削除する
		if (property.getDefine() instanceof PropertyDefine) {
			property.setDefine(null);
		}
	}

	/**
	 * プロパティ位置の取得
	 * 
	 * @param parent
	 * @param property
	 * @return プロパティ位置
	 */
	public static int getPropertyIndex(Property parent, Property property) {
		Object[] childrens = parent.getChildren();
		int index = -1;

		for (int i = 0; i < childrens.length; i++) {
			Property children = (Property) childrens[i];
			if (children.hashCode() == property.hashCode()) {
				index = i;
				break;
			}
		}

		return index;
	}

	/**
	 * Propertyクラスをコピーする
	 * 
	 * @param original
	 * @return コピーしたPropertyクラス
	 */
	public static Property copy(Property original) {
		Property clone = new Property(original.getID(), original.getName(),
				original.getEditor());

		clone.setParent(original.getParent());
		clone.setModify(original.getModify());
		clone.setCopy(original.getCopy());
		clone.setUpperBound(original.getUpperBound());
		clone.setLowerBound(original.getLowerBound());
		clone.setStringUpperValue(original.getStringUpperValue());

		Object[][] selectValues = original.getSelectValues();
		Object[] childrens = original.getChildren();
		PropertyDefine define = original.getDefine();

		if (selectValues != null) {
			Object[][] cloneSelectValues = {
					new Object[selectValues[PropertyConstant.SELECT_DISP_TEXT].length],
					new Object[selectValues[PropertyConstant.SELECT_VALUE].length] };
			for (int i = 0; i < selectValues[PropertyConstant.SELECT_DISP_TEXT].length; i++) {
				cloneSelectValues[PropertyConstant.SELECT_DISP_TEXT][i] = selectValues[PropertyConstant.SELECT_DISP_TEXT][i];
			}
			for (int i = 0; i < selectValues[PropertyConstant.SELECT_VALUE].length; i++) {
				if (selectValues[PropertyConstant.SELECT_VALUE][i] instanceof HashMap) {
					HashMap cloneMap = new HashMap();
					ArrayList clonPropertyList = new ArrayList();

					HashMap map = (HashMap) selectValues[PropertyConstant.SELECT_VALUE][i];
					ArrayList propertyList = (ArrayList) map
					.get(PropertyConstant.MAP_PROPERTY);
					if (propertyList instanceof ArrayList) {
						for (int j = 0; j < propertyList.size(); j++) {
							Property children = (Property) propertyList.get(j);
							Property clonechildren = copy(children);
							clonPropertyList.add(clonechildren);
						}
					}
					cloneMap.put(PropertyConstant.MAP_VALUE, map
							.get(PropertyConstant.MAP_VALUE));
					cloneMap.put(PropertyConstant.MAP_PROPERTY,
							clonPropertyList);

					cloneSelectValues[PropertyConstant.SELECT_VALUE][i] = cloneMap;
				} else {
					cloneSelectValues[PropertyConstant.SELECT_VALUE][i] = selectValues[PropertyConstant.SELECT_VALUE][i];
				}
			}
			clone.setSelectValues(cloneSelectValues);
		} else {
			for (int i = 0; i < childrens.length; i++) {
				Property children = (Property) childrens[i];
				Property cloneChildren = copy(children);
				clone.addChildren(cloneChildren);
			}
		}

		/*
        if (define instanceof ComboPropertyDefine) {
            int index = 0;

            if (original.getValue() != null) {
//                String dispText = (String) original.getValue();
//                for (int i = 0; i < selectValues[PropertyConstant.SELECT_DISP_TEXT].length; i++) {
//                    if (dispText
//                            .compareTo((String)selectValues[PropertyConstant.SELECT_DISP_TEXT][i]) == 0) {
//                        index = i;
//                        break;
//                    }
//                }
                String value = (String) original.getValue();
                for (int i = 0; i < selectValues[PropertyConstant.SELECT_VALUE].length; i++) {
                    if (value.compareTo((String)selectValues[PropertyConstant.SELECT_VALUE][i]) == 0) {
                        index = i;
                        break;
                    }
                }

            }

            clone.setDefine(new ComboPropertyDefine(clone.getSelectValues()));

            if (selectValues[PropertyConstant.SELECT_VALUE][index] instanceof HashMap) {
                HashMap map = (HashMap) selectValues[PropertyConstant.SELECT_VALUE][index];
                clone.setValue(map.get(PropertyConstant.MAP_VALUE));

                ArrayList propertyList = (ArrayList) map
                        .get(PropertyConstant.MAP_PROPERTY);
                if (propertyList instanceof ArrayList) {
                    clone.removeChildren();
                    for (int i = 0; i < propertyList.size(); i++) {
                        clone.addChildren((Property) propertyList.get(i));
                    }
                }
            } else {
                clone.removeChildren();
//                Object select = selectValues[PropertyConstant.SELECT_DISP_TEXT][index];
                Object select = selectValues[PropertyConstant.SELECT_VALUE][index];
                clone.setValue(select);
            }
        } else if (define instanceof FilePropertyDefine) {
            clone.setDefine(new FilePropertyDefine());
            clone.setValue(original.getValue());
        } else if (define instanceof TextPropertyDefine) {
            clone.setDefine(new TextPropertyDefine());
            clone.setValue(original.getValue());
        } else if (define instanceof PasswordPropertyDefine) {
            clone.setDefine(new PasswordPropertyDefine());
            clone.setValue(original.getValue());
        } else if (define instanceof ScopePropertyDefine) {
            clone.setDefine(new ScopePropertyDefine());
            clone.setValue(original.getValue());
        } else if (define instanceof BooleanPropertyDefine) {
            clone.setDefine(new BooleanPropertyDefine());
            clone.setValue(original.getValue());
        } else if (define instanceof IntegerPropertyDefine) {
            clone.setDefine(new IntegerPropertyDefine());
            clone.setValue(original.getValue());
        } else if (define instanceof DatePropertyDefine) {
            clone.setDefine(new DatePropertyDefine());
            clone.setValue(original.getValue());
        } else if (define instanceof DateTimePropertyDefine) {
            clone.setDefine(new DateTimePropertyDefine());
            clone.setValue(original.getValue());
        } else if (define instanceof TimePropertyDefine) {
            clone.setDefine(new TimePropertyDefine());
            clone.setValue(original.getValue());
        } else if (define instanceof TextAreaPropertyDefine) {

        	//テキストエリアの場合、独自にフラグを持っている（デフォルトfalse）ので、コピー時に変更する
        	TextAreaPropertyDefine def = new TextAreaPropertyDefine();
        	if (clone.getModify() == PropertyConstant.MODIFY_OK) {
            	def.setModify(true);
        	}
            clone.setDefine(def);
            clone.setValue(original.getValue());
        } else {
            clone.setValue(original.getValue());
        }
		 */
		/*
		 * ここの修正は怪しい。
		 * 後で調査すること！！！
		 * TODO
		 * TODO
		 * TODO
		 */
		clone.setDefine(original.getDefine());
		clone.setValue(original.getValue());

		return clone;
	}

	/**
	 * プロパティの変更を設定する（再帰呼び出し）
	 * 
	 * @param property
	 * @param modify
	 */
	public static void setPropertyModify(Property property, int modify) {

		//子プロパティを検索する
		if (property.getEditor() instanceof String
				&& property.getEditor().compareTo(
						PropertyConstant.EDITOR_SELECT) == 0) {
			Object[][] value = property.getSelectValues();
			for (int j = 0; j < value[PropertyConstant.SELECT_VALUE].length; j++) {
				if (value[PropertyConstant.SELECT_VALUE][j] instanceof HashMap) {
					HashMap map = (HashMap) value[PropertyConstant.SELECT_VALUE][j];

					//子Propertyを取得
					ArrayList propertyList = (ArrayList) map
					.get(PropertyConstant.MAP_PROPERTY);
					if (propertyList instanceof ArrayList) {
						for (int k = 0; k < propertyList.size(); k++) {
							Property children2 = (Property) propertyList.get(k);
							setPropertyModify(children2, modify);
						}
					}
				}
			}
		}

		//子Propertyを取得
		Object[] childrens = property.getChildren();

		for (int i = 0; i < childrens.length; i++) {
			Property children1 = (Property) childrens[i];
			setPropertyModify(children1, modify);
		}

		//Property変更をNGにする
		property.setModify(modify);
	}

	/**
	 * プロパティ値設定処理（再帰呼び出し）
	 * 
	 * @param property
	 * @param editor
	 * @param value
	 */
	public static void setPropertyValue(Property property, String editor,
			Object value) {

		//エディタが一致するプロパティに値を設定
		if (property.getEditor().equals(editor)) {
			property.setValue(value);
		}

		//子プロパティを検索する
		if (property.getEditor() instanceof String
				&& property.getEditor().compareTo(
						PropertyConstant.EDITOR_SELECT) == 0) {
			Object[][] selectValue = property.getSelectValues();
			for (int j = 0; j < selectValue[PropertyConstant.SELECT_VALUE].length; j++) {
				if (selectValue[PropertyConstant.SELECT_VALUE][j] instanceof HashMap) {
					HashMap map = (HashMap) selectValue[PropertyConstant.SELECT_VALUE][j];

					//子Propertyを取得
					ArrayList propertyList = (ArrayList) map
					.get(PropertyConstant.MAP_PROPERTY);
					if (propertyList instanceof ArrayList) {
						for (int k = 0; k < propertyList.size(); k++) {
							Property children2 = (Property) propertyList.get(k);
							setPropertyValue(children2, editor, value);
						}
					}
				}
			}
		} else {
			//子Propertyを取得
			Object[] childrens = property.getChildren();

			for (int i = 0; i < childrens.length; i++) {
				Property children1 = (Property) childrens[i];
				setPropertyValue(children1, editor, value);
			}
		}
	}
}