/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.accesscontrol.composite.UserListComposite;
import com.clustercontrol.accesscontrol.composite.action.UserListSelectionChangedListener;
import com.clustercontrol.accesscontrol.view.action.ModifyPasswordAction;
import com.clustercontrol.accesscontrol.view.action.UserAddAction;
import com.clustercontrol.accesscontrol.view.action.UserDeleteAction;
import com.clustercontrol.accesscontrol.view.action.UserModifyAction;
import com.clustercontrol.bean.Property;
import com.clustercontrol.view.CommonViewPart;

/**
 * アクセス[ユーザ]ビュークラス<BR>
 * 
 * クライアントの画面を構成します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserListView extends CommonViewPart {
	/** ビューID */
	public static final String ID = "com.clustercontrol.accesscontrol.view.UserListView";

	/** アクセス[ユーザ]ビュー用のコンポジット */
	private UserListComposite m_userList = null;

	/** フィルタ条件 */
	private Property m_condition = null;

	/**
	 * コンストラクタ
	 */
	public UserListView() {
		super();
	}

	/**
	 * ビューを構築します。
	 * 
	 * @param parent 親コンポジット
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 * @see #createContextMenu()
	 * @see #update()
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		m_userList = new UserListComposite(parent, SWT.NONE, this);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_userList.setLayoutData(gridData);

		//ポップアップメニュー作成
		createContextMenu();

		// ボタン（アクション）を制御するリスナーを登録
		this.m_userList.getTableViewer().addSelectionChangedListener(
				new UserListSelectionChangedListener());

		//ビューを更新
		this.update();
	}

	/**
	 * コンテキストメニューを作成します。
	 * 
	 * @see org.eclipse.jface.action.MenuManager
	 * @see org.eclipse.swt.widgets.Menu
	 */
	protected void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			/* (non-Javadoc)
			 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
			 */
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(m_userList.getTable());
		m_userList.getTable().setMenu(menu);
	}

	/**
	 * コンテキストメニューに項目を追加します。
	 * 
	 * @param manager メニューマネージャ
	 * 
	 * @see org.eclipse.jface.action.IToolBarManager
	 * @see org.eclipse.jface.action.IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		//ビューのアクションのインスタンスを取得
		IToolBarManager toolbar =
			this.getViewSite().getActionBars().getToolBarManager();
		ActionContributionItem userAdd =
			(ActionContributionItem) toolbar.find(UserAddAction.ID);
		ActionContributionItem userModify =
			(ActionContributionItem) toolbar.find(UserModifyAction.ID);
		ActionContributionItem userDelete =
			(ActionContributionItem) toolbar.find(UserDeleteAction.ID);
		ActionContributionItem modifyPassword =
			(ActionContributionItem) toolbar.find(ModifyPasswordAction.ID);

		//ポップアップメニューにアクションを追加
		manager.add(userAdd.getAction());
		manager.add(userModify.getAction());
		manager.add(userDelete.getAction());
		manager.add(modifyPassword.getAction());
	}

	/**
	 * フィルタ条件取得
	 * 
	 * @return フィルタ条件
	 */
	public Property getFilterCondition() {
		return m_condition;
	}

	/**
	 * フィルタ条件設定
	 * 
	 * @param condition フィルタ条件
	 */
	public void setFilterCondition(Property condition) {
		m_condition = condition;
	}

	/**
	 * ビューを更新します。
	 * 
	 * @see com.clustercontrol.accesscontrol.composite.UserListComposite#update()
	 * @see com.clustercontrol.accesscontrol.composite.UserListComposite#update(Property)
	 */
	public void update() {
		if (m_condition == null) {
			m_userList.update();
		} else {
			m_userList.update(m_condition);
		}
	}

	/**
	 * ビューを更新します。
	 * 
	 * @param condition フィルタ条件
	 * 
	 * @see com.clustercontrol.accesscontrol.composite.UserListComposite#update(Property)
	 */
	public void update(Property condition) {
		this.m_condition = condition;

		this.update();
	}

	/**
	 * アクセス[ユーザ]ビュー用のコンポジットを返します。
	 * 
	 * @return アクセス[ユーザ]ビュー用のコンポジット
	 */
	public UserListComposite getComposite() {
		return m_userList;
	}

	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 */
	public void setEnabledAction(int num, ISelection selection) {
		//ビューアクションの使用可/不可を設定
		super.setEnabledAction(UserModifyAction.ID, selection);
		super.setEnabledAction(UserDeleteAction.ID, selection);
		super.setEnabledAction(ModifyPasswordAction.ID, selection);

		if (num > 0){
			super.setEnabledAction(UserModifyAction.ID, true);
			super.setEnabledAction(UserDeleteAction.ID, true);
			super.setEnabledAction(ModifyPasswordAction.ID, true);
		} else {
			super.setEnabledAction(UserModifyAction.ID, false);
			super.setEnabledAction(UserDeleteAction.ID, false);
			super.setEnabledAction(ModifyPasswordAction.ID, false);
		}
	}
}