package com.clustercontrol.calendar.util;

import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.EndpointManager.EndpointSetting;
import com.clustercontrol.ws.calendar.CalendarAddInfo;
import com.clustercontrol.ws.calendar.HinemosUnknown_Exception;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;
import com.clustercontrol.ws.calendar.InvalidSetting_Exception;
import com.clustercontrol.ws.calendar.InvalidUserPass_Exception;
import com.clustercontrol.ws.calendar.CalendarDuplicate_Exception;
import com.clustercontrol.ws.calendar.CalendarEndpoint;
import com.clustercontrol.ws.calendar.CalendarInfo;
import com.clustercontrol.ws.calendar.CalendarNotFound_Exception;
import com.clustercontrol.ws.calendar.ScheduleInfo;
import com.clustercontrol.ws.calendar.WeekdayInfo;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class CalendarEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( CalendarEndpointWrapper.class );

	public static CalendarInfo getCalendar(String id) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				return endpoint.getCalendar(id);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getCalendar(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void addCalendar(CalendarInfo calendarInfo) throws CalendarDuplicate_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception,InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				endpoint.addCalendar(calendarInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addCalendar(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void deleteCalendar(String uid) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				endpoint.deleteCalendar(uid);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteCalendar(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static WeekdayInfo getWeekday(String id, Integer weekday, Long from, Long to) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				return endpoint.getWeekday(id, weekday, from, to);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getWeekday(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<CalendarInfo> getCalendarList() throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				return endpoint.getCalendarList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getCalendarList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<WeekdayInfo> getWeekdayList(String calendarId) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				return endpoint.getWeekdayList(calendarId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getWeekdayList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<CalendarAddInfo> getAddList(String calendarId) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				return endpoint.getAddList(calendarId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getAddList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<ScheduleInfo> getSchedule(long base) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				return endpoint.getSchedule(base);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getSchedule(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyCalendar(CalendarInfo calendarInfo) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyCalendar(calendarInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyCalendar(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void addWeekday(String id, WeekdayInfo weekdayInfo) throws CalendarDuplicate_Exception, CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				endpoint.addWeekday(id, weekdayInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addWeekday(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyWeekday(String id, Integer weekday, Long from, Long to, WeekdayInfo weekdayInfo) throws CalendarDuplicate_Exception, CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyWeekday(id, weekday, from, to, weekdayInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyWeekday(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void deleteWeekday(String id, Integer weekday, Long from, Long to) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				endpoint.deleteWeekday(id, weekday, from, to);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteWeekday(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static CalendarAddInfo getCalendarAdd(String id, Long from, Long to) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				return endpoint.getCalendarAdd(id, from, to);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getCalendarAdd(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void addCalendarAdd(String id, CalendarAddInfo calendarAddInfo) throws CalendarDuplicate_Exception, CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				endpoint.addCalendarAdd(id, calendarAddInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addCalendarAdd(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyCalendarAdd(String id, Long from, Long to, CalendarAddInfo calendarAddInfo) throws CalendarDuplicate_Exception, CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyCalendarAdd(id, from, to, calendarAddInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyCalendarAdd(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void deleteCalendarAdd(String id, Long from, Long to) throws CalendarNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getCalendarEndpoint()) {
			try {
				CalendarEndpoint endpoint = (CalendarEndpoint) endpointSetting.getEndpoint();
				endpoint.deleteCalendarAdd(id, from, to);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteCalendarAdd(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
