/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view.action;

import java.util.ArrayList;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.composite.ScheduleListComposite;
import com.clustercontrol.jobmanagement.dialog.ScheduleDialog;
import com.clustercontrol.jobmanagement.view.ScheduleListView;

/**
 * ジョブ[スケジュール]ビューの「変更」のクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ModifyScheduleAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.action.ModifyScheduleAction";
	/** ビュー */
	protected IViewPart m_view;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart view) {
		m_view = view;
	}

	/**
	 * ジョブ[スケジュール]ビューの「変更」が押された場合に、スケジュールを作成します。
	 * <p>
	 * <ol>
	 * <li>ジョブ[スケジュール]ビューから選択されたスケジュールを取得します。</li>
	 * <li>ジョブ[スケジュールの作成・変更]ダイアログを表示します。</li>
	 * <li>ジョブ[スケジュール]ビューを更新します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.jobmanagement.dialog.ScheduleDialog
	 * @see com.clustercontrol.jobmanagement.view.ScheduleListView
	 * @see com.clustercontrol.jobmanagement.composite.ScheduleListComposite
	 */
	@Override
	public void run(IAction action) {
		if (m_view instanceof ScheduleListView) {
			ScheduleListView view = (ScheduleListView) m_view
			.getAdapter(ScheduleListView.class);
			ScheduleListComposite composite = view.getComposite();

			ArrayList item = composite.getSelectItem();
			if (item instanceof ArrayList) {
				//ダイアログ表示
				ScheduleDialog dialog = new ScheduleDialog(PlatformUI
						.getWorkbench().getActiveWorkbenchWindow().getShell());
				dialog.setSchedule(item);
				dialog.open();
			}

			view.update();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {

	}
}