/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.view.action;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.maintenance.action.GetMaintenanceListTableDefine;
import com.clustercontrol.maintenance.composite.MaintenanceListComposite;
import com.clustercontrol.maintenance.util.MaintenanceEndpointWrapper;
import com.clustercontrol.maintenance.view.MaintenanceListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.maintenance.InvalidRole_Exception;

/**
 * メンテナンス[一覧]ビューの[有効]アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */

public class MaintenanceEnableAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( MaintenanceEnableAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.maintenance.view.action.MaintenanceEnableAction";

	/** ビュー */
	private IViewPart viewPart;

	@Override
	public void run(IAction action) {

		// 選択アイテムの取得

		MaintenanceListView view = (MaintenanceListView)this.viewPart.getAdapter(MaintenanceListView.class);
		MaintenanceListComposite composite = (MaintenanceListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		Object [] objs = selection.toArray();

		// 1つも選択されていない場合
		if(objs.length == 0){
			MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.maintenance.9"));
			return;
		}

		// 1つ以上選択されている場合
		String maintenanceId = null;
		String[] args;
		StringBuffer targetList = new StringBuffer();
		StringBuffer successList = new StringBuffer();
		StringBuffer failureList = new StringBuffer();
		for (Object o : objs) {
			if (targetList.length() != 0) {
				targetList.append(", ");
			}
			maintenanceId = (String) ((ArrayList)o).get(GetMaintenanceListTableDefine.MAINTENANCE_ID);
			targetList.append(maintenanceId);
		}

		// 実行確認(NG→終了)
		args = new String[]{ targetList.toString() } ;
		if (!MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				Messages.getString("message.maintenance.14", args))) {
			return;
		}

		boolean hasRole = true; //設定権限を持っているかどうか
		// 実行
		for(Object o : objs){
			maintenanceId = (String) ((ArrayList)o).get(GetMaintenanceListTableDefine.MAINTENANCE_ID);

			try{
				MaintenanceEndpointWrapper.setMaintenanceStatus(maintenanceId, true);
				successList.append(maintenanceId + "\n");
			}catch (InvalidRole_Exception e) {
				failureList.append(maintenanceId + "\n");
				m_log.warn("run() setMaintenanceStatus maintenanceId=" + maintenanceId + ", " + e.getMessage(), e);
				hasRole = false;
			}catch (Exception e) {
				failureList.append(maintenanceId + "\n");
				m_log.warn("run() setMaintenanceStatus maintenanceId=" + maintenanceId + ", " + e.getMessage(), e);
			}
		}

		if (!hasRole) {
			// 権限がない場合にはエラーメッセージを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		}
		
		// 成功ダイアログ
		if(successList.length() != 0){
			args = new String[]{ successList.toString() } ;
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					Messages.getString("message.maintenance.18", args));
		}

		// 失敗ダイアログ
		if(failureList.length() != 0){
			args = new String[]{ failureList.toString() } ;
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.maintenance.19", args));
		}

		// ビューコンポジット更新
		composite.update();

	}

	/**
	 * 選択時のアクションの有効/無効の判定
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * viewPartの設定
	 */
	@Override
	public void init(IViewPart view) {
		this.viewPart = view;
	}

}
