/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.view.action;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.repository.action.GetAgentListTableDefine;
import com.clustercontrol.repository.bean.AgentCommandConstant;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.repository.view.AgentListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.repository.InvalidRole_Exception;

/**
 * ノードの作成・変更ダイアログによる、ノード登録を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 1.0.0
 */
public class AgentUpdateAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( AgentUpdateAction.class );

	public static final String ID = "com.clustercontrol.repository.view.action.AgentUpdateAction";

	//	 ----- instance フィールド ----- //

	private IViewPart viewPart; // ビュー

	// ----- instance メソッド ----- //

	/**
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		AgentListView view = (AgentListView) this.viewPart
		.getAdapter(AgentListView.class);

		StructuredSelection selection = (StructuredSelection) view
		.getComposite().getTableViewer().getSelection();

		List selectionList = selection.toList();
		if (selectionList.size() == 0) {
			return;
		}
		ArrayList<String> facilityIdList = new ArrayList<String>();
		String message = "";
		boolean flag = true;
		for (Object o : selectionList) {
			List list = (List) o;
			String facilityId = null;
			String facilityName = null;
			if (list != null) {
				facilityId = (String) list.get(GetAgentListTableDefine.FACILITY_ID);
				facilityName = (String) list.get(GetAgentListTableDefine.FACILITY_NAME);
				facilityIdList.add(facilityId);
			}

			// ファシリティIDがおかしい場合は、リターンする。
			if (facilityId == null) {
				return;
			} else if ("".equals(facilityId)) {
				return;
			}

			// 複数選択した場合はカンマでつなげる。
			if (flag) {
				flag = false;
			} else {
				message += ", ";
			}
			message += facilityName + "(" + facilityId + ")";
		}

		// 確認する。
		String[] args = { message };
		if (!MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				Messages.getString("message.repository.45", args))) {
			m_log.debug("cancel");
			return;
		}

		try {
			RepositoryEndpointWrapper.restartAgent(facilityIdList, AgentCommandConstant.UPDATE);
		} catch (InvalidRole_Exception e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(
					null,
					Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (Exception e) {
			m_log.warn("run(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}