/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.sql.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;

/**
 * SQL監視設定情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class GetSql {

	// ログ
	private static Log m_log = LogFactory.getLog( GetSql.class );

	/**
	 * SQL監視情報を返します。
	 * 
	 * @param monitorId 監視項目ID
	 * @return SQL監視情報
	 */
	public MonitorInfo getSql(String monitorId) {

		MonitorInfo info = null;

		try {
			info = MonitorSettingEndpointWrapper.getMonitor(monitorId, HinemosModuleConstant.MONITOR_SQL);

		} catch (InvalidRole_Exception e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(
					null,
					Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));

		} catch (Exception e) {
			// 上記以外の例外
			m_log.warn("getSql(), " + e.getMessage(), e);
			MessageDialog.openInformation(
					null,
					Messages.getString("message"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}

		return info;
	}
}