/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

import com.clustercontrol.commons.bean.Schedule;

/**
 * ジョブのスケジュールに関する情報を保持するクラス<BR>
 * 
 */
@XmlType(namespace = "http://jobmanagement.ws.clustercontrol.com")
public class JobSchedule implements Serializable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 2798625217156631572L;

	/** スケジュールID */
	private String m_id;

	/** スケジュール名 */
	private String m_name;

	/** ジョブID */
	private String m_jobId;

	/** ジョブ名 */
	private String m_jobName;

	/** ジョブユニットID */
	private String m_jobunitId;

	/** スケジュール */
	private Schedule m_schedule;

	/** カレンダID */
	private String m_calendarId;

	/** 新規作成ユーザ */
	private String m_createUser;

	/** 作成日時 */
	private Long m_createTime;

	/** 最新更新ユーザ */
	private String m_updateUser;

	/** 最新更新日時 */
	private Long m_updateTime;

	/** 有効/無効 */
	private Integer m_valid = new Integer(0);

	/**
	 * スケジュールIDを返す<BR>
	 * @return スケジュールID
	 */
	public String getId() {
		return m_id;
	}

	/**
	 * スケジュールIDを設定する<BR>
	 * @param id スケジュールID
	 */
	public void setId(String id) {
		this.m_id = id;
	}

	/**
	 * ジョブIDを返す<BR>
	 * @return ジョブID
	 */
	public String getJobId() {
		return m_jobId;
	}

	/**
	 * ジョブIDを設定する<BR>
	 * @param jobId ジョブID
	 */
	public void setJobId(String jobId) {
		this.m_jobId = jobId;
	}

	/**
	 * ジョブ名を返す<BR>
	 * @return ジョブ名
	 */
	public String getJobName() {
		return m_jobName;
	}

	/**
	 * ジョブ名を設定する<BR>
	 * @param jobName ジョブ名
	 */
	public void setJobName(String jobName) {
		this.m_jobName = jobName;
	}

	/**
	 * スケジュール名を返す<BR>
	 * @return スケジュール名
	 */
	public String getName() {
		return m_name;
	}

	/**
	 * スケジュール名を設定する<BR>
	 * @param name スケジュール名
	 */
	public void setName(String name) {
		this.m_name = name;
	}

	/**
	 * 有効/無効を返す<BR>
	 * @return 有効/無効
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public Integer getValid() {
		return m_valid;
	}

	/**
	 * 有効/無効を設定する<BR>
	 * @param valid 有効/無効
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setValid(Integer valid) {
		this.m_valid = valid;
	}

	/**
	 * 作成日時を返す<BR>
	 * @return 作成日時
	 */
	public Long getCreateTime() {
		return m_createTime;
	}

	/**
	 * 作成日時を設定する<BR>
	 * @param createTime 作成日時
	 */
	public void setCreateTime(Long createTime) {
		this.m_createTime = createTime;
	}

	/**
	 * 最新更新日時を返す<BR>
	 * @return 最新更新日時
	 */
	public Long getUpdateTime() {
		return m_updateTime;
	}

	/**
	 * 最新更新日時を設定する<BR>
	 * @param updateTime 最新更新日時
	 */
	public void setUpdateTime(Long updateTime) {
		this.m_updateTime = updateTime;
	}

	/**
	 * スケジュールを返す<BR>
	 * @return スケジュール
	 */
	public Schedule getSchedule() {
		return m_schedule;
	}

	/**
	 * スケジュールを設定する<BR>
	 * @param schedule スケジュール
	 */
	public void setSchedule(Schedule schedule) {
		this.m_schedule = schedule;
	}

	/**
	 * カレンダIDを返す<BR>
	 * @return カレンダID
	 */
	public String getCalendarId() {
		return m_calendarId;
	}

	/**
	 * カレンダIDを設定する<BR>
	 * @param calendarId カレンダID
	 */
	public void setCalendarId(String calendarId) {
		this.m_calendarId = calendarId;
	}

	/**
	 * 新規作成ユーザを返す<BR>
	 * @return 新規作成ユーザ
	 */
	public String getCreateUser() {
		return m_createUser;
	}

	/**
	 * 新規作成ユーザを設定する<BR>
	 * @param createUser 新規作成ユーザ
	 */
	public void setCreateUser(String createUser) {
		this.m_createUser = createUser;
	}

	/**
	 * 最新更新ユーザを返す<BR>
	 * @return 最新更新ユーザ
	 */
	public String getUpdateUser() {
		return m_updateUser;
	}

	/**
	 * 最新更新ユーザを設定する<BR>
	 * @param updateUser 最新更新ユーザ
	 */
	public void setUpdateUser(String updateUser) {
		this.m_updateUser = updateUser;
	}

	/**
	 * 所属ジョブユニットのジョブIDを返す<BR>
	 * @return 所属ジョブユニットのジョブID
	 */
	public String getJobunitId() {
		return m_jobunitId;
	}

	/**
	 * 所属ジョブユニットのジョブIDを設定する<BR>
	 * @param jobunitId 所属ジョブユニットのジョブID
	 */
	public void setJobunitId(String jobunitId) {
		m_jobunitId = jobunitId;
	}


}