package com.clustercontrol.notify.util;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyInfoDetail;
import com.clustercontrol.notify.ejb.entity.NotifyDetail;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;

public class NotifyCache {
	private static Log m_log = LogFactory.getLog( NotifyCache.class );

	private static Object notifyMapLock = new Object();
	private static ConcurrentHashMap<String, NotifyInfo> notifyMap = null;
	private static ConcurrentHashMap<String, NotifyInfoDetail> notifyDetailMap = null;

	/**
	 * キャッシュをリフレッシュする。
	 * 通知の登録、変更、削除時に呼ぶ。
	 */
	public static void refresh() {
		long startTime = System.currentTimeMillis();
		int size = 0;
		int sizeD = 0;
		synchronized (notifyMapLock) {
			notifyMap = new ConcurrentHashMap<String, NotifyInfo>();
			notifyDetailMap = new ConcurrentHashMap<String, NotifyInfoDetail>();
			try {
				Collection<NotifyInfoLocal> c = NotifyInfoUtil.getLocalHome().findAll();
				for (NotifyInfoLocal local : c) {
					NotifyInfo info = new NotifyInfo();
					String notifyId = local.getNotifyId();
					info.setNotifyId(notifyId);
					// info.setDescription(local.getDescription());
					info.setNotifyType(local.getNotifyType());
					info.setInitialCount(local.getInitialCount());
					info.setRenotifyType(local.getRenotifyType());
					info.setRenotifyPeriod(local.getRenotifyPeriod());
					// info.setRegDate(local.getRegDate().getTime());
					// info.setUpdateDate(local.getUpdateDate().getTime());
					// info.setRegUser(local.getRegUser());
					// info.setUpdateUser(local.getUpdateUser());
					info.setValidFlg(local.getValidFlg());
					notifyMap.put(notifyId, info);

					for (int priority : PriorityConstant.PRIORITY_LIST) {
						NotifyDetail detail = local.getNotifyDetail(priority);
						NotifyInfoDetail notifyInfoDetail = new NotifyInfoDetail();
						notifyInfoDetail.setNotifyId(notifyId);
						notifyInfoDetail.setPriority(priority);
						notifyInfoDetail.setValidFlg(detail.getValidFlg());
						notifyDetailMap.put(createKey(notifyId, priority), notifyInfoDetail);
					}
				}
				size = notifyMap.size();
				sizeD = notifyDetailMap.size();
			} catch (Exception e) {
				m_log.error("create notifyCache failed : " + e.getMessage(), e);
			}
		}
		long endTime = System.currentTimeMillis();
		m_log.info("refresh NotifyCache. " + (endTime - startTime)
				+ "ms. size=" + size + ". detail size=" + sizeD);
	}

	private static void init () {
		if (notifyMap == null) {
			refresh();
		}
	}

	/**
	 * NodeInfoをキャッシュから取得する。
	 * NodeInfoは性能向上のため、メンバ変数の一部が欠けているため注意すること。
	 * @param notifyId
	 * @return
	 */
	public static NotifyInfo getNotifyInfo(String notifyId) {
		init ();
		NotifyInfo notifyInfo = null;
		synchronized (notifyMapLock) {
			notifyInfo = notifyMap.get(notifyId);
		}
		if (notifyInfo == null) {
			m_log.warn("notifyInfo is null");
		}
		return notifyInfo;
	}

	/**
	 * NotifyInfoDetailをキャッシュから取得する。
	 * @param notifyId
	 * @param priority
	 * @return
	 */
	public static NotifyInfoDetail getNotifyInfoDetail(String notifyId, int priority) {
		init ();
		NotifyInfoDetail notifyInfoDetail = null;
		synchronized (notifyMapLock) {
			notifyInfoDetail = notifyDetailMap.get(createKey(notifyId, priority));
		}
		if (notifyInfoDetail == null) {
			m_log.warn("notifyInfoDetail is null");
		}
		return notifyInfoDetail;
	}

	private static String createKey (String notifyId, int priority) {
		return notifyId + "," + priority;
	}
}
