/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.util;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.entity.NodeLocal;

/**
 * 通知に関するUtilityクラス<br/>
 * 
 * @author takahatats
 */
public class NotifyUtil {

	private static Log log = LogFactory.getLog(NotifyUtil.class);

	private static final String _KEY_PRIORITY = "PRIORITY";
	private static final String _KEY_PRIORITY_NUM = "PRIORITY_NUM";
	private static final String _KEY_PRIORITY_JP = "PRIORITY_JP";
	private static final String _KEY_PRIORITY_EN = "PRIORITY_EN";

	private static final String _KEY_PLUGIN_ID = "PLUGIN_ID";
	private static final String _KEY_MONITOR_ID = "MONITOR_ID";
	private static final String _KEY_FACILITY_ID = "FACILITY_ID";
	private static final String _KEY_SCOPE = "SCOPE";

	private static final String _KEY_FACILITY_NAME = "FACILITY_NAME";
	private static final String _KEY_IP_ADDRESS = "IP_ADDRESS";
	private static final String _KEY_IP_ADDRESS_V4 = "IP_ADDRESS_V4";
	private static final String _KEY_IP_ADDRESS_V6 = "IP_ADDRESS_V6";
	private static final String _KEY_NODE_NAME = "NODE_NAME";

	private static final String _KEY_GENERATION_DATE = "GENERATION_DATE";
	private static final String _KEY_APPLICATION = "APPLICATION";
	private static final String _KEY_MESSAGE_ID = "MESSAGE_ID";
	private static final String _KEY_MESSAGE = "MESSAGE";
	private static final String _KEY_ORG_MESSAGE = "ORG_MESSAGE";

	/** 日時フォーマット。 */
	private static String SUBJECT_DATE_FORMAT ;

	/** 日時フォーマットデフォルト。 */
	private static String SUBJECT_DATE_FORMAT_DEFAULT = "yyyy/MM/dd HH:mm:ss" ;

	static {
		SUBJECT_DATE_FORMAT = HinemosProperties.getProperty("common.notify.date.format", SUBJECT_DATE_FORMAT_DEFAULT);
		if(log.isDebugEnabled()){
			log.debug("TextReplacer.static SUBJECT_DATE_FORMAT = " + SUBJECT_DATE_FORMAT);
		}
	}

	/**
	 * 通知情報をハッシュとして返す。
	 * @param info 通知情報
	 * @return 通知情報のハッシュ
	 */
	public static Map<String, String> createParameter(OutputBasicInfo info) {
		Map<String, String> param = null;
		SimpleDateFormat sdf = null;

		if (info != null) {
			param = new HashMap<String, String>();
			sdf = new SimpleDateFormat(SUBJECT_DATE_FORMAT);

			param.put(_KEY_PRIORITY_NUM, String.valueOf(info.getPriority()));
			if (PriorityConstant.typeToString(info.getPriority()) != null) {
				param.put(_KEY_PRIORITY, PriorityConstant.typeToString(info.getPriority()));
			} else {
				param.put(_KEY_PRIORITY, null);
			}
			if (PriorityConstant.typeToStringJP(info.getPriority()) != null) {
				param.put(_KEY_PRIORITY_JP, PriorityConstant.typeToStringJP(info.getPriority()));
			} else {
				param.put(_KEY_PRIORITY_JP, null);
			}
			if (PriorityConstant.typeToStringEN(info.getPriority()) != null) {
				param.put(_KEY_PRIORITY_EN, PriorityConstant.typeToStringEN(info.getPriority()));
			} else {
				param.put(_KEY_PRIORITY_EN, null);
			}

			param.put(_KEY_PLUGIN_ID, info.getPluginId());
			param.put(_KEY_MONITOR_ID, info.getMonitorId());
			param.put(_KEY_FACILITY_ID, info.getFacilityId());
			param.put(_KEY_SCOPE, info.getScopeText());

			if (info.getGenerationDate() != null) {
				param.put(_KEY_GENERATION_DATE, sdf.format(info.getGenerationDate()));
			} else {
				param.put(_KEY_GENERATION_DATE, null);
			}
			param.put(_KEY_APPLICATION, info.getApplication());
			param.put(_KEY_MESSAGE_ID, info.getMessageId());
			param.put(_KEY_MESSAGE, info.getMessage());
			param.put(_KEY_ORG_MESSAGE, info.getMessageOrg());

			if (info.getFacilityId() != null) {
				try {
					FacilityLocal facility = FacilityUtil.getLocalHome().findByPrimaryKey(info.getFacilityId());
					param.put(_KEY_FACILITY_NAME, facility.getFacilityName());
					if (facility.isNode()) {
						NodeLocal node = facility.getNode();
						param.put(_KEY_NODE_NAME, node.getNodeName());
						param.put(_KEY_IP_ADDRESS_V4, node.getIpAddressV4());
						param.put(_KEY_IP_ADDRESS_V6, node.getIpAddressV6());
						param.put(_KEY_IP_ADDRESS, node.getIpAddressVersion() == 4 ? node.getIpAddressV4() : node.getIpAddressV6());
					}
				} catch (Exception e) {
					log.info("facility not found. (" + info.getFacilityId() + ")");
				}
			}

		}

		return param;
	}
}
