/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * 収集した性能値を格納するDTOクラス
 * 
 * 収集日時と性能値をペアで保持します。
 * 
 * @version 4.0.0
 * @since 4.0.0
 *
 */
@XmlType(namespace = "http://monitor.ws.clustercontrol.com")
public class CollectedDataInfo implements Serializable {
private static final long serialVersionUID = -126607156053910561L;

// webサービス(jaxb)のため、finalははずしておく
private String m_itemCode;      //収集項目コード
private String m_displayName;    //リポジトリ表示名
private Long m_dateTime;        //収集日時
private String m_facilityId;    //ファシリティID
private Double m_value = new Double(0);         //性能値
private Integer m_errorType = new Integer(0);        //値が不正な場合のエラーパターン

public CollectedDataInfo(){
	super();
	this.m_facilityId = null;
	this.m_itemCode = null;
	this.m_displayName = null;
	this.m_dateTime = null;
	this.m_value = Double.NaN;
	this.m_errorType = CollectedDataErrorTypeConstant.NOT_ERROR;;
}

/**
 * ファシリティID, 収集項目ID, デバイス名, 性能値を格納したCollectedDataInfoオブジェクトを生成します。<br>
 * 
 * @param facilityId ファシリティID
 * @param itemCode 収集項目ID
 * @param deviceName デバイス名
 * @param value 性能値
 */
public CollectedDataInfo(final String facilityId, final String itemCode, final String displayName, final Long date, final Double value) {
	this.m_facilityId = facilityId;
	this.m_itemCode = itemCode;
	this.m_displayName = displayName;
	this.m_dateTime = date;
	this.m_value = value;
	this.m_errorType = CollectedDataErrorTypeConstant.NOT_ERROR;
}

/**
 * 性能値の算出に失敗した場合のインスタンスを生成します。
 * ファシリティID, 収集項目ID, デバイス名, 性能値を格納したCollectedDataInfoオブジェクトを生成します。<br>
 * 格納される性能値は、Double.NaNとなります。
 * 
 * @param facilityId ファシリティID
 * @param itemCode 収集項目ID
 * @param deviceName デバイス名
 * @param errorType エラー種別
 */
public CollectedDataInfo(final String facilityId, final String itemCode, final String displayName, final Long date, final Integer errorType) {
	this.m_facilityId = facilityId;
	this.m_itemCode = itemCode;
	this.m_displayName = displayName;
	this.m_dateTime = date;
	this.m_value = Double.NaN;
	this.m_errorType = errorType;
}

/**
 * 収集項目コードを取得します。
 * @return 収集項目コード
 */
public String getItemCode() {
	return m_itemCode;
}

// webサービス(jaxb)のため、setterを用意しておく。
@Deprecated
public void setItemCode(String itemCode) {
	m_itemCode = itemCode;
}

/**
 * リポジトリ表示名を取得します。
 * @return
 */
public String getDisplayName() {
	return m_displayName;
}

// webサービス(jaxb)のため、setterを用意しておく。
@Deprecated
public void setDisplayName(String displayName){
	m_displayName = displayName;
}

/**
 * 収集日時 を取得します。
 * @return 収集日時
 */
public Long getDate() {
	return m_dateTime;
}

public void setDate(Long time) {
	m_dateTime = time;
}

/**
 * ファシリティID を取得します。
 * @return ファシリティID
 */
public String getFacilityId() {
	return m_facilityId;
}

// webサービス(jaxb)のため、setterを用意しておく。
@Deprecated
public void setFacilityId(String facilityId){
	m_facilityId = facilityId;
}

/**
 * 性能値 を取得します。
 * @return  性能値
 */
public Double getValue() {
	return m_value;
}

// webサービス(jaxb)のため、setterを用意しておく。
@Deprecated
public void setValue(Double value){
	m_value = value;
}

/**
 * エラー種別を返します。
 */
public Integer getErrorType(){
	return m_errorType;
}

// webサービス(jaxb)のため、setterを用意しておく。
@Deprecated
public void setErrorType(Integer errorType){
	m_errorType = errorType;
}

/**
 * データの内容を文字列として返します。
 */
@Override
public String toString(){
	String str =
		"FID:" + m_facilityId +
		"  Item:" +  m_itemCode +
		"." + m_displayName +
		"  " + m_dateTime +
		" : " + m_value;
	return str;
}
}