/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstPK;

/**
 * 収集毎の計算方法の情報を保持するEntity Bean <BR>
 * @ejb.bean name="CollectorItemCalcMethodMst"
 *           jndi-name="CollectorItemCalcMethodMst"
 *           type="CMP"
 *           view-type="local"
 *           schema="CollectorItemCalcMethodMst"
 *           cmp-version="2.x"
 *           data-source="java:/DefaultDS"
 * 
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_collector_item_calc_method_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *
 *  @jboss.read-only read-only="true"
 *
 *  @ejb.permission
 *     unchecked="true"
 * 
 *  @ejb.persistence
 *   table-name="cc_collector_item_calc_method_mst"
 * 
 *  @ejb.finder
 *    query="SELECT OBJECT(a) FROM CollectorItemCalcMethodMst as a"
 *    signature="java.util.Collection findAll()"
 * 
 *  @ejb.finder
 *    query="SELECT OBJECT(a) FROM CollectorItemCalcMethodMst as a where a.platformId = ?1 AND a.subPlatformId = ?2"
 *    signature="java.util.Collection findByPlatformIdAndSubPlatformId(java.lang.String platformId, java.lang.String subPlatformId)"
 *
 *  @ejb.pk class="com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstPK"
 * 
 */
public abstract class CollectorItemCalcMethodMstBean implements EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public CollectorItemCalcMethodMstPK ejbCreate(
			String collectMethod,
			String platformId,
			String subPlatformId,
			String itemCode,
			String calcMethod
	) throws javax.ejb.CreateException {

		this.setCollectMethod(collectMethod);
		this.setPlatformId(platformId);
		this.setSubPlatformId(subPlatformId);
		this.setItemCode(itemCode);
		this.setCalcMethod(calcMethod);

		return null;
	}

	/**
	 * コンストラクター
	 * @param collectMethod 収集方法
	 * @param platformId プラットフォーム
	 * @param itemCode 収集項目コード
	 * @param calcMethod 計算方法
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String collectMethod,
			String platformId,
			String subPlatformId,
			String itemCode,
			String calcMethod
	) throws javax.ejb.CreateException {
	}

	/**
	 * 収集方法を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="collect_method"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the collectMethod.
	 */
	public abstract String getCollectMethod();

	/**
	 * 収集方法を設定します。
	 * 
	 * @param collectMethod The collectMethod to set.
	 */
	public abstract void setCollectMethod(String collectMethod);

	/**
	 * プラットフォームを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the platformId.
	 */
	public abstract String getPlatformId();

	/**
	 * プラットフォームを設定します。
	 * 
	 * @param platformId The platformId to set.
	 */
	public abstract void setPlatformId(String platformId);

	/**
	 * サブプラットフォームを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="sub_platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the subPlatformId.
	 */
	public abstract String getSubPlatformId();

	/**
	 * サブプラットフォームを設定します。
	 * 
	 * @param subPlatformId The subPlatformId to set.
	 */
	public abstract void setSubPlatformId(String subPlatformId);

	/**
	 * 収集項目コードを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="item_code"
	 *     jdbc-type="CHAR"
	 *     sql-type="CHARACTER(8)"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the itemCode.
	 */
	public abstract String getItemCode();

	/**
	 * 収集項目コードを設定します。
	 * 
	 * @param itemCode The itemCode to set.
	 */
	public abstract void setItemCode(String itemCode);

	/**
	 * 計算方法を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="calc_method"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the calcMethod.
	 */
	public abstract String getCalcMethod();

	/**
	 * 計算方法を設定します。
	 * 
	 * @param calcMethod The calcMethod to set.
	 */
	public abstract void setCalcMethod(String calcMethod);

}
