/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapPK;

/**
 * 値の型定義情報を管理するEntity Bean <BR>
 * @ejb.bean name="CollectorScopeSnap"
 *           jndi-name="CollectorScopeSnap"
 *           type="CMP"
 *           view-type="local"
 *           schema="CollectorScopeSnap"
 *           cmp-version="2.x"
 *           data-source="java:/DefaultDS"
 * 
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_collector_scope_snap"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 *  @jboss.read-only
 *     read-only="true"
 * 
 *  @ejb.permission
 *     unchecked="true"
 * 
 *  @ejb.persistence
 *   table-name="cc_collector_scope_snap"
 * 
 *  @ejb.finder
 *    query="SELECT OBJECT(a) FROM CollectorScopeSnap as a"
 *    signature="java.util.Collection findAll()"
 *
 *  @ejb.finder
 *    query="SELECT OBJECT(a) FROM CollectorScopeSnap as a where a.collectorId = ?1"
 *    signature="java.util.Collection findByCollectorId(java.lang.String collectorId)"
 *
 *  @ejb.pk class="com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapPK"
 * 
 */
public abstract class CollectorScopeSnapBean implements EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public CollectorScopeSnapPK ejbCreate(
			String collectorId,   //収集ID
			String facilityId,    //ファシリティID
			String platformId,    //プラットフォーム種別
			String subPlatformId, //サブプラットフォーム種別
			String facilityName,  //ファシリティ名称
			String facilityType   //ファシリティ種別
	) throws javax.ejb.CreateException {

		this.setCollectorId(collectorId);
		this.setFacilityId(facilityId);
		this.setPlatformId(platformId);
		this.setSubPlatformId(subPlatformId);
		this.setFacilityName(facilityName);
		this.setFacilityType(facilityType);

		return null;
	}

	/**
	 * コンストラクター
	 * @param collectorId 収集ID
	 * @param facilityId ファシリティID
	 * @param platformId プラットフォーム種別
	 * @param subPlatformId サブプラットフォーム種別
	 * @param facilityName ファシリティ名称
	 * @param facilityType ファシリティ種別
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String collectorId,
			String facilityId,
			String platformId,
			String subPlatformId,
			String facilityName,
			String facilityType
	) throws javax.ejb.CreateException {
	}

	/**
	 * 収集IDを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="collectorid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the collectorId.
	 */
	public abstract String getCollectorId();

	/**
	 * 収集IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param collectorId The collectorId to set.
	 */
	public abstract void setCollectorId(String collectorId);

	/**
	 * ファシリティIDを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="facilityid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityId.
	 */
	public abstract String getFacilityId();

	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId The facilityId to set.
	 */
	public abstract void setFacilityId(String facilityId);

	/**
	 * プラットフォーム種別を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the platformId.
	 */
	public abstract String getPlatformId();

	/**
	 * プラットフォーム種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param platformId The platformId to set.
	 */
	public abstract void setPlatformId(String platformId);

	/**
	 * サブプラットフォーム種別を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="sub_platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the subPlatformId.
	 */
	public abstract String getSubPlatformId();

	/**
	 * サブプラットフォーム種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param subPlatformId The subPlatformId to set.
	 */
	public abstract void setSubPlatformId(String subPlatformId);

	/**
	 * ファシリティ名称を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="facility_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityName.
	 */
	public abstract String getFacilityName();

	/**
	 * ファシリティ名称を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityName The facilityName to set.
	 */
	public abstract void setFacilityName(String facilityName);

	/**
	 * ファシリティ種別を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="facility_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(16)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityType.
	 */
	public abstract String getFacilityType();

	/**
	 * ファシリティ種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityType The facilityType to set.
	 */
	public abstract void setFacilityType(String facilityType);

}
