package com.clustercontrol.performance.monitor.util;

import java.util.ArrayList;
import java.util.concurrent.Callable;

import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import com.clustercontrol.monitor.run.bean.MonitorRunResultInfo;
import com.clustercontrol.performance.monitor.factory.RunMonitorPerformance;

/**
 * リソース監視を実行するクラスです
 * 
 * @author hinemos
 *
 */
public class CallablePerfTask implements Callable<ArrayList<MonitorRunResultInfo>> {

	private RunMonitorPerformance m_runMonitor;
	private String m_facilityId;

	/**
	 * 
	 * @param monitor
	 * @param facilityId
	 */
	public CallablePerfTask(RunMonitorPerformance monitor, String facilityId) {
		m_runMonitor = monitor;
		m_facilityId = facilityId;
	}
	@Override
	public ArrayList<MonitorRunResultInfo> call() throws Exception {
		// 結果を格納
		ArrayList<MonitorRunResultInfo> infoList = new ArrayList<MonitorRunResultInfo>();

		// トランザクションを開始
		TransactionManager tm = null;
		Transaction oldTx = null;
		try{
			// TransactionManagerを取得
			InitialContext context = new InitialContext();
			tm = (TransactionManager)context.lookup("java:/TransactionManager");

			// 実行中のスレッドがトランザクションに関連付けられている場合は、トランザクションを退避
			if(tm.getTransaction() != null){
				oldTx = tm.suspend();
			}

			// トランザクション開始
			if(tm.getTransaction() == null){
				tm.begin();
			}

			// 各監視処理を実行し、実行の可否を格納
			infoList = m_runMonitor.collectList(m_facilityId);

			// コミット
			tm.commit();

		}finally{
			// 一時停止していたトランザクションを再開
			if(oldTx != null){
				tm.resume(oldTx);
			}
		}

		return infoList;
	}

}
