/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.operator;

/**
 * 100-var0/(var1+var2)*100を求めます。
 */
public class InvPercentage12 extends Operator {
@Override
public double calc() throws CollectedDataNotFoundException, InvalidValueException{
double total;
double perfData;

total = getCurrentMibValue("var1") + getCurrentMibValue("var2");

if(total == 0){
// エラー処理　おそらく値がとれていない
return Double.NaN;
}

perfData = 100.0D - getCurrentMibValue("var0") / total * 100.0D;

return perfData;
}
}
