/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.performance.util;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.bean.PerfData;
import com.clustercontrol.performance.bean.Sample;
import com.clustercontrol.performance.dao.CalculatedDataDAO;

/**
 * 性能情報を登録するユーティティクラス<BR>
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public class PerformanceDataUtil {

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( PerformanceDataUtil.class );

	private static CalculatedDataDAO cDao = new CalculatedDataDAO();

	/**
	 * 性能情報を登録するために Queue に put する
	 * 
	 * @param sample 性能情報
	 */
	public static void put(Sample sample){
		m_log.debug("put() start");

		//  for debug
		if(m_log.isDebugEnabled()){
			m_log.debug("put() collectorId = " + sample.getCollectorId() + ", dateTime = " + sample.getDateTime());
			ArrayList<PerfData> list = sample.getPerfDataList();
			for (PerfData data : list){
				m_log.info("put() list facilityId = " + data.getFacilityId() + ", value = " + data.getValue());
			}
		}

		cDao.insert(sample);

		m_log.debug("put() end");
	}
}
