/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.process.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * プロセス監視プロパティ情報を取得するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ProcessProperties {
	private static Log m_log = LogFactory.getLog( ProcessProperties.class );

	private static final String START_SECOND = "10";
	private static final String VALID_SECOND = "15";
	private static final String DETAILED_DISPLAY = "false";

	private static final String START_SECOND_KEY = "monitor.process.start.second";
	private static final String VALID_SECOND_KEY = "monitor.process.valid.second";
	private static final String DETAILED_DISPLAY_KEY = "monitor.process.details.display";

	private static ProcessProperties m_instance = null;

	/** プロセス監視値取得開始時間（秒） */
	private int m_startSecond;
	/** SNMPポーラー収集許容時間（秒） */
	private int m_validSecond;
	/** オリジナルメッセージにプロセスを表示させるかのフラグ */
	private boolean m_detailedDisplay;

	/**
	 * このオブジェクトを取得します。
	 * 
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @return ConnectionManager コネクションマネージャ
	 */
	public static ProcessProperties getProperties() {
		if (m_instance==null) {
			m_instance = new ProcessProperties();
		}
		return m_instance;
	}

	/**
	 * コンストラクタ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private ProcessProperties() {
		this.setValue();
	}

	/**
	 * プロセス監視情報をプロパティファイルから取得
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private void setValue() {

		Properties properties = new Properties();

		try {
			String etcdir = System.getProperty("hinemos.manager.etc.dir");
			String propertyFile = etcdir + File.separator + "hinemos.properties";

			// プロパティファイルからキーと値のリストを読み込みます
			properties.load(new FileInputStream(propertyFile));

			String startSecond = properties.getProperty(START_SECOND_KEY, START_SECOND);
			String validSecond = properties.getProperty(VALID_SECOND_KEY, VALID_SECOND);
			String detailedDisplay = properties.getProperty(DETAILED_DISPLAY_KEY, DETAILED_DISPLAY);

			if(startSecond != null && !startSecond.equals(""))
				m_startSecond = new Integer(startSecond).intValue();

			if(validSecond != null && !validSecond.equals(""))
				m_validSecond = new Integer(validSecond).intValue();

			if(detailedDisplay != null && !detailedDisplay.equals(""))
				m_detailedDisplay = new Boolean(detailedDisplay).booleanValue();

		} catch (Exception e) {
			m_log.error("setValue(): " + e.getMessage());
		}
	}

	/**
	 * @return m_startSecond を戻します。
	 */
	public int getStartSecond() {
		return m_startSecond;
	}

	/**
	 * @return m_validSecond を戻します。
	 */
	public int getValidSecond() {
		return m_validSecond;
	}

	/**
	 * @return m_detailsDisplay を戻します。
	 */
	public boolean isDetailedDisplay() {
		return m_detailedDisplay;
	}
}
