
package com.clustercontrol.ws.xcloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>storageStatusのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="storageStatus">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="processing"/>
 *     &lt;enumeration value="available"/>
 *     &lt;enumeration value="in_use"/>
 *     &lt;enumeration value="deleted"/>
 *     &lt;enumeration value="unknown"/>
 *     &lt;enumeration value="notfound"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "storageStatus")
@XmlEnum
public enum StorageStatus {

    @XmlEnumValue("processing")
    PROCESSING("processing"),
    @XmlEnumValue("available")
    AVAILABLE("available"),
    @XmlEnumValue("in_use")
    IN_USE("in_use"),
    @XmlEnumValue("deleted")
    DELETED("deleted"),
    @XmlEnumValue("unknown")
    UNKNOWN("unknown"),
    @XmlEnumValue("notfound")
    NOTFOUND("notfound");
    private final String value;

    StorageStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static StorageStatus fromValue(String v) {
        for (StorageStatus c: StorageStatus.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
