package com.clustercontrol.xcloud.aws.plugin;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_AvailabilityZone;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_Subnet;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_Vpc;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.FOLDER_AZ;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.FOLDER_SUBNET;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.FOLDER_VPC;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.FOLDER_VPC_AZ;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.Image;

import com.clustercontrol.xcloud.aws.common.AWSConstants;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.IModelContentProvider;
import com.clustercontrol.xcloud.model.cloud.IResource;
import com.clustercontrol.xcloud.model.repository.ICloudScopeRootScope;
import com.clustercontrol.xcloud.model.repository.ICloudScopeScope;
import com.clustercontrol.xcloud.model.repository.IEntityNode;
import com.clustercontrol.xcloud.model.repository.IFacility;
import com.clustercontrol.xcloud.model.repository.IFolderScope;
import com.clustercontrol.xcloud.model.repository.IInstanceNode;
import com.clustercontrol.xcloud.model.repository.ILocationScope;
import com.clustercontrol.xcloud.model.repository.INode;
import com.clustercontrol.xcloud.model.repository.IScope;

public class AWSModelContentProvider implements IModelContentProvider, CloudStringConstants, AWSStringConstants {
	public static class FacilityModelTransformor<T> implements IFacility.ITransformer<T> {
		protected T defaultValue;
		public FacilityModelTransformor(T defaultValue) {this.defaultValue = defaultValue;}
		@Override public T transform(IFacility facility) {return defaultTransform(facility);}
		@Override public T transform(INode node) {return defaultTransform(node);}
		@Override public T transform(IScope scope) {return defaultTransform(scope);}
		@Override public T transform(ILocationScope scope) {return defaultTransform(scope);}
		@Override public T transform(IFolderScope scope) {return defaultTransform(scope);}
		@Override public T transform(ICloudScopeScope scope) {return defaultTransform(scope);}
		@Override public T transform(ICloudScopeRootScope scope) {return defaultTransform(scope);}
		@Override public T transform(IInstanceNode node) {return defaultTransform(node);}
		@Override public T transform(IEntityNode node) {return defaultTransform(node);}
		protected T defaultTransform(IFacility facility) {return defaultValue;}
	}
	
	@Override
	public Object getParent(Object o, Object defaultParent) {
		return defaultParent;
	}

	@Override
	public String getText(Object o, String defaultName) {
		if (o instanceof IFacility) {
			return ((IFacility)o).transform(new FacilityModelTransformor<String>(defaultName) {
				@Override public String transform(ICloudScopeScope scope) {
					return strAws + " ( " + scope.getName() + " )";
				}
				@Override public String transform(IFolderScope folder) {
					switch (folder.getFolderType()) {
					case AWSConstants.FOLDER_AZ:
					case AWSConstants.FOLDER_VPC_AZ:
						return String.format("%s (%s)", strAvailabilityZone, folder.getName());
					case AWSConstants.FOLDER_VPC:
						return String.format("%s (%s)", strVPC, folder.getName());
					case AWSConstants.FOLDER_SUBNET:
						return String.format("%s (%s)", strSubnet, folder.getName());
					default:
						return defaultValue;
					}
				}
				@Override public String transform(ILocationScope location) {
					return location.getName();
				}
				@Override public String transform(IInstanceNode instance) {
					return String.format("%s (%s)", strInstance, instance.getName());
				}
				@Override public String transform(IEntityNode node) {
					return String.format("%s (%s)", node.getEntityType(), node.getName());
				}
			});
		}
		return defaultName;
	}

	@Override
	public Image getImage(Object o, Image defaultImage) {
		if (o instanceof IFacility) {
			return ((IFacility)o).transform(new FacilityModelTransformor<Image>(defaultImage) {
			});
		}
		return defaultImage;
	}
	
	protected void filterResource(IFolderScope folder, List<IResource> src, List<IResource> dest) {
		if (src.isEmpty())
			return;

		String az = null;
		String vpc = null;
		String subnet = null;
		
		switch (folder.getFolderType()) {
		case FOLDER_AZ:
			az = folder.getExtendedProperty(EPROP_AvailabilityZone);
			break;
		case FOLDER_VPC_AZ:
			az = folder.getExtendedProperty(EPROP_AvailabilityZone);
			vpc = folder.getExtendedProperty(EPROP_Vpc);
			break;
		case FOLDER_VPC:
			vpc = folder.getExtendedProperty(EPROP_Vpc);
			break;
		case FOLDER_SUBNET:
			subnet = folder.getExtendedProperty(EPROP_Subnet);
			break;
		}
		
		Iterator<IResource> iter = src.iterator();
		while (iter.hasNext()) {
			IResource resource = iter.next();
			if (!((az == null || az.equals(resource.getExtendedProperty(EPROP_AvailabilityZone))) &&
					(vpc == null || vpc.equals(resource.getExtendedProperty(EPROP_Vpc))) &&
					(subnet == null || subnet.equals(resource.getExtendedProperty(EPROP_Subnet)))))
					continue;
				
			dest.add(resource);
			iter.remove();
		}
		
		for (IFacility facility: folder.getFacilities()) {
			if (!(facility instanceof IFolderScope))
				continue;
			filterResource((IFolderScope)facility, src, dest);
		}
	}

	@Override
	public <T> T[] getChildren(Object o, final T[] defaultChildren) {
		if (o instanceof IFacility) {
			return ((IFacility)o).transform(new FacilityModelTransformor<T[]>(defaultChildren) {
				@SuppressWarnings("unchecked")
				@Override
				public T[] transform(IFolderScope scope) {
					Class<?> componentType = defaultValue.getClass().getComponentType();
					if (!IResource.class.isAssignableFrom(componentType))
						return defaultTransform(scope);
					
					List<IResource> src = new ArrayList<>(Arrays.asList((IResource[])defaultChildren));
					List<IResource> dest = new ArrayList<>();
					filterResource(scope, src, dest);
					
					return (T[])dest.toArray((T[])Array.newInstance(componentType, dest.size()));
				}
			});
		}
		return defaultChildren;
	}
}