/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.aws.ui.dialogs;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_AvailabilityZone;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_Cidr;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_Vpc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AWSOptionEndpoint;
import com.clustercontrol.ws.xcloud.AddNetworkInterfaceRequest;
import com.clustercontrol.ws.xcloud.CloudManagerException;
import com.clustercontrol.ws.xcloud.InvalidRole_Exception;
import com.clustercontrol.ws.xcloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.xcloud.SecurityGroup;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.CloudModelException;
import com.clustercontrol.xcloud.model.cloud.ILocation;
import com.clustercontrol.xcloud.model.cloud.INetwork;
import com.clustercontrol.xcloud.ui.dialogs.IDialogConstants;
import com.clustercontrol.xcloud.util.ControlUtil;

public class CreateNetworkInterfaceDialog extends Dialog implements CloudStringConstants, AWSStringConstants {
	protected ILocation location;
	protected INetwork subnet;
	
	protected AWSResourceProvider provider;
	protected CheckboxTableViewer tableViewer;
	protected Text text;
	protected Text text_1;
	private Text text_2;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateNetworkInterfaceDialog(Shell parentShell, INetwork subnet, AWSResourceProvider provider) {
		super(parentShell);
		this.location = subnet.getLocation();
		this.subnet = subnet;
		this.provider = provider;
	}
	
	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.heightHint = 422;
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblNewLabel = new Label(container, SWT.RIGHT);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText(strManager + strSeparator);
		
		Label lblNewLabel_4 = new Label(container, SWT.BORDER);
		lblNewLabel_4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_4.setText(location.getCloudScope().getCloudScopes().getHinemosManager().getManagerName());
		
		Label lblNewLabel_1 = new Label(container, SWT.RIGHT);
		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText(strCloudScope + strSeparator);
		
		Label lblNewLabel_5 = new Label(container, SWT.BORDER);
		lblNewLabel_5.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_5.setText(String.format("%s (%s)", location.getCloudScope().getName(), location.getCloudScope().getId()));
		
		Label lblid = new Label(container, SWT.RIGHT);
		lblid.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblid.setText(strSubnet + strSeparator);
				
		Label lblNewLabel_3 = new Label(container, SWT.BORDER);
		lblNewLabel_3.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblNewLabel_3.setText(String.format("%s(%s, %s)", subnet.getId(), subnet.getExtendedProperty(EPROP_Cidr), subnet.getExtendedProperty(EPROP_AvailabilityZone)));
		
		Label label_1 = new Label(container, SWT.NONE);
		label_1.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		label_1.setText(strInterfaceName + strSeparator);
		
		text_2 = new Text(container, SWT.BORDER);
		text_2.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkFinished();
			}
		});
		text_2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));

		Label lblRegion = new Label(container, SWT.RIGHT);
		lblRegion.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblRegion.setText(strPrivateIp + strSeparator);
		
		text = new Text(container, SWT.BORDER);
		text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label label = new Label(container, SWT.RIGHT);
		label.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		label.setText(strDescription + strSeparator);
		
		text_1 = new Text(container, SWT.BORDER | SWT.WRAP);
		GridData gd_text_1 = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_text_1.heightHint = 71;
		text_1.setLayoutData(gd_text_1);
		
		Label lblNewLabel_2 = new Label(container, SWT.RIGHT);
		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblNewLabel_2.setText(strSecurityGroup + strSeparator);
		
		tableViewer = CheckboxTableViewer.newCheckList(container, SWT.BORDER | SWT.CHECK | SWT.FULL_SELECTION);
		tableViewer.addCheckStateListener(new ICheckStateListener() {
			public void checkStateChanged(CheckStateChangedEvent event) {
				checkFinished();
			}
		});
		Table table = tableViewer.getTable();
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, false, true, 1, 1);
		gd_table.heightHint = 237;
		table.setLayoutData(gd_table);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		
		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
		tblclmnNewColumn.setWidth(140);
		tblclmnNewColumn.setText(strSecurityGroupId + strSeparator);
		tableViewerColumn.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {return ((SecurityGroup)element).getGroupId();}
		});
		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
		tblclmnNewColumn_1.setWidth(159);
		tblclmnNewColumn_1.setText(strSecurityGroupName + strSeparator);
		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {return ((SecurityGroup)element).getGroupName();}
		});
		tableViewer.setContentProvider(new ArrayContentProvider());
		
		String vpcId = subnet.getExtendedProperty(EPROP_Vpc);
		
		List<SecurityGroup> sgs = new ArrayList<>();
		for (SecurityGroup sg: provider.getSecurityGroups()) {
			if (vpcId.equals(sg.getVpcId())) {
				sgs.add(sg);
			}
		}
		tableViewer.setInput(sgs);
		
		ControlUtil.setRequired(new Control[]{text_2, table});

		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				checkFinished();
			}
		});
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(540, 434);
	}

	@Override
	protected void okPressed() {
		AWSOptionEndpoint endpoint = location.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(AWSOptionEndpoint.class);
		
		AddNetworkInterfaceRequest request = new AddNetworkInterfaceRequest();
		request.setSubnetId(subnet.getId());
		request.setNetworkInterfaceName(text_2.getText());
		request.setDescription(text_1.getText());
		String ip = text.getText();
		request.setPrivateIp(ip == null || ip.isEmpty() ? null: ip);
		
		for (Object obj: tableViewer.getCheckedElements()) {
			request.getSecurityGroupIds().add(((SecurityGroup)obj).getGroupId());
		}
		
		try {
			endpoint.addNetworkInterface(location.getCloudScope().getId(), location.getId(), request);
		} catch (CloudManagerException | InvalidRole_Exception | InvalidUserPass_Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);

			String message = e.getMessage();
			if (message == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos, true);
				e.printStackTrace(ps);
				
				message = bos.toString();
			}
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), message);
			throw new CloudModelException(e);
		}

		super.okPressed();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(dlgInterfaceCreate);
	}
	
	protected void checkFinished() {
		Button okButton = getButton(IDialogConstants.OK_ID);
		if (okButton == null)
			return;
			
		if (text_2 != null && !text_2.getText().isEmpty() &&
			tableViewer != null && tableViewer.getCheckedElements().length > 0
			) {
			getButton(IDialogConstants.OK_ID).setEnabled(true);
		} else {
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}
	}
}
