/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.xcloud.aws.ui.dialogs;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.bundle_messages;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.Filter;
import com.clustercontrol.ws.xcloud.Image;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.ui.dialogs.IDialogConstants;

public class SelectAMIDialog extends Dialog implements CloudStringConstants, AWSStringConstants {
	private Table ami;
	private Text filter;

	private AWSResourceProvider provider;
	
	private Image output;
	
	private String strSearchAmi = bundle_messages.getString("word.search_ami");
	private String msgMustInputSearchText = bundle_messages.getString("message.must_input_search_text");
	private String strAmiList = bundle_messages.getString("word.ami_list");
	private String msgMustSelectAmi = bundle_messages.getString("message.must_select_ami");
	private String strSelectAmiDialog = bundle_messages.getString("caption.select_ami_dialog");

	/**
	 * Create the dialog.				// リージョンを取得する。

	 * @param parentShell
	 */
	public SelectAMIDialog(Shell parentShell, AWSResourceProvider provider) {
		super(parentShell);
		setShellStyle(SWT.CLOSE | SWT.RESIZE | SWT.TITLE | SWT.APPLICATION_MODAL);
		this.provider = provider;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayout(new GridLayout(3, false));
		container.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Label lblTestfilter = new Label(container, SWT.RIGHT);
		lblTestfilter.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblTestfilter.setText(strKeyword + strSeparator);
		
		filter = new Text(container, SWT.BORDER);
		filter.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				if (e.character == '\r')
					searchAmi();
			}
		});
		filter.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		Button btnSearch = new Button(container, SWT.NONE);
		GridData gd_btnSearch = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_btnSearch.heightHint = 17;
		gd_btnSearch.widthHint = 61;
		btnSearch.setLayoutData(gd_btnSearch);
		btnSearch.setText(strSearchAmi);
		btnSearch.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				searchAmi();
			}
		});
		
		Label lblAmiList = new Label(container, SWT.NONE);
		lblAmiList.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		lblAmiList.setText(strAmiList + strSeparator);
		
		ami = new Table(container, SWT.BORDER | SWT.FULL_SELECTION);
		ami.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				getButton(IDialogConstants.OK_ID).setEnabled(ami.getSelectionIndex() != -1);
			}
		});
		ami.setLinesVisible(true);
		ami.setHeaderVisible(true);
		GridData gd_ami = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_ami.heightHint = 303;
		ami.setLayoutData(gd_ami);
		
		TableColumn tblclmnAmiId = new TableColumn(ami, SWT.NONE);
		tblclmnAmiId.setWidth(100);
		tblclmnAmiId.setText("AMI ID");
		
		TableColumn tblclmnNewColumn = new TableColumn(ami, SWT.NONE);
		tblclmnNewColumn.setWidth(160);
		tblclmnNewColumn.setText(strName);
		
		TableColumn tblclmnNewColumn_1 = new TableColumn(ami, SWT.NONE);
		tblclmnNewColumn_1.setWidth(160);
		tblclmnNewColumn_1.setText(strDescription);

		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				getButton(IDialogConstants.OK_ID).setEnabled(false);
			}
		});
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(598, 480);
	}

	@Override
	protected void okPressed() {
		if (ami.getSelection().length == 0) {
			MessageDialog.openError(null, Messages.getString("failed"), msgMustSelectAmi);
			return;
		}
		
		output = (Image)ami.getItem(ami.getSelectionIndex()).getData();
		
		super.okPressed();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strSelectAmiDialog);
	}
	
	public Image getOutput() {
		return output;
	}
	
	protected void searchAmi() {
		if(filter.getText() == ""){
			MessageDialog.openWarning(null, Messages.getString("failed"), msgMustInputSearchText);
			return;
		}
		ami.removeAll();
		
		try {
			Set<Image> imageSet = new TreeSet<>(new Comparator<Image>() {
				@Override
				public int compare(Image o1, Image o2) {
					return o1.getId().compareTo(o2.getId());
				}
			});
			for (String name: Arrays.asList("name", "image-id", "description")) {
				Filter f1 = new Filter();
				f1.setName(name);
				f1.getValues().add("*"+filter.getText()+"*");
				Filter f2 = new Filter();
				f2.setName("image-type");
				f2.getValues().add("machine");
				List<Image> images = provider.getImages(Arrays.asList(f1, f2));
				
				for (Image i: images) {
					imageSet.add(i);
				}
			}
			for (Image image: imageSet) {
				TableItem item = new TableItem(ami, SWT.None);
				item.setText(0, image.getId());
				item.setText(1, image.getName());
				item.setText(2, image.getDescription() == null ? "": image.getDescription());
				item.setData(image);
			}
		} catch(Exception e1) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e1.getMessage(), e1);
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), e1.getMessage());
		}
	}
}