package com.clustercontrol.xcloud.aws.ui.dialogs.job;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;

import com.clustercontrol.jobmanagement.util.JobEditState;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.util.JobTreeItemUtil;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.Option;
import com.clustercontrol.xcloud.common.CloudConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.CloudOptionExtension;
import com.clustercontrol.xcloud.model.cloud.IHinemosManager;
import com.clustercontrol.xcloud.model.cloud.IStorage;
import com.clustercontrol.xcloud.ui.dialogs.job.FacilityTreePage;
import com.clustercontrol.xcloud.ui.dialogs.job.JobDetailPage;
import com.clustercontrol.xcloud.ui.dialogs.job.JobTreePage;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;


public class AttachStorageJobWizard extends Wizard implements CloudStringConstants {
	@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
	public abstract class JobTreeItemMixin {
		@JsonIdentityReference(alwaysAsId = true)
		public abstract JobTreeItem getParent();
	}
	
	protected IStorage storage;
	protected final String ownerRoleId;
	protected boolean firstShowDetail;
	protected CloudEndpoint endpoint;
	
	public AttachStorageJobWizard(CloudEndpoint endpoint, IStorage storage, String ownerRoleId) {
		setWindowTitle(MessageFormat.format(dlgStorageAttach, CloudOptionExtension.getOptions().get(storage.getCloudScope().getCloudPlatform().getId())));
		this.ownerRoleId = ownerRoleId;
		this.endpoint = endpoint;
		this.storage = storage;
	}
	
	public AttachStorageJobWizard(CloudEndpoint endpoint, IStorage storage) {
		setWindowTitle(MessageFormat.format(dlgStorageAttach, CloudOptionExtension.getOptions().get(storage.getCloudScope().getCloudPlatform().getId())));
		this.ownerRoleId = null;
		this.endpoint = endpoint;
		this.storage = storage;
	}

	@Override
	public void addPages() {
		addPage(new JobTreePage(storage.getHinemosManager().getManagerName(), ownerRoleId));
		addPage(new JobDetailPage());
		addPage(new SelectInstancePage(storage));
	}

	@Override
	public boolean performFinish() {
		try {
			List<String> facilities;
			facilities = endpoint.getManagerFacilityIds();
			if (facilities.isEmpty()) {
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), CloudConstants.bundle_messages.getString("message.job.manager_node.not_found"));
				return false;
			}
		
			JobDetailPage detailPage = (JobDetailPage)getPage(JobDetailPage.pageName);
			JobTreePage jobPage = (JobTreePage)getPage(JobTreePage.pageName);
			SelectInstancePage instancePage = (SelectInstancePage)getPage(SelectInstancePage.pageName);
			
			JobTreeItem parent = jobPage.getSelectedItem();
			
			ObjectMapper objectMapper = new ObjectMapper();
			objectMapper.addMixIn(JobTreeItem.class, JobTreeItemMixin.class);
			ObjectReader reader = objectMapper.reader(JobTreeItem.class);
			
			JobTreeItem item;
			item = reader.readValue("{\"@id\":1,\"children\":[],\"data\":{\"abnormalPriority\":0,\"beginPriority\":3,\"command\":{\"messageRetryEndFlg\":1,\"messageRetryEndValue\":-1,\"commandRetry\":10,\"commandRetryFlg\":0,\"facilityID\":\"\",\"messageRetry\":10,\"processingMethod\":0,\"scope\":\"オーナー別スコープ>name02>\",\"specifyUser\":0,\"startCommand\":\"\",\"stopCommand\":null,\"stopType\":1,\"user\":null},\"createTime\":null,\"createUser\":null,\"description\":\"\",\"endStatus\":[{\"endRangeValue\":0,\"startRangeValue\":0,\"type\":0,\"value\":0},{\"endRangeValue\":1,\"startRangeValue\":1,\"type\":1,\"value\":1},{\"endRangeValue\":null,\"startRangeValue\":null,\"type\":2,\"value\":-1}],\"file\":null,\"id\":\"scope01_role02_i-poweron-1\",\"jobunitId\":\"autocontrol\",\"name\":\"\",\"normalPriority\":3,\"notifyRelationInfos\":[],\"ownerRoleId\":\"\",\"param\":[],\"parentId\":null,\"propertyFull\":true,\"referJobId\":null,\"referJobUnitId\":null,\"type\":2,\"updateTime\":null,\"updateUser\":null,\"waitRule\":{\"calendar\":0,\"calendarEndStatus\":2,\"calendarEndValue\":0,\"calendarId\":null,\"condition\":0,\"endCondition\":1,\"endStatus\":2,\"endValue\":-1,\"endDelay\":0,\"endDelayConditionType\":0,\"endDelayJob\":0,\"endDelayJobValue\":1,\"endDelayNotify\":0,\"endDelayNotifyPriority\":0,\"endDelayOperation\":0,\"endDelayOperationEndStatus\":2,\"endDelayOperationEndValue\":-1,\"endDelayOperationType\":0,\"endDelaySession\":0,\"endDelaySessionValue\":1,\"endDelayTime\":0,\"endDelayTimeValue\":null,\"multiplicityEndValue\":-1,\"multiplicityNotify\":1,\"multiplicityNotifyPriority\":2,\"multiplicityOperation\":0,\"object\":[],\"skip\":0,\"skipEndStatus\":2,\"skipEndValue\":0,\"startDelay\":0,\"startDelayConditionType\":0,\"startDelayNotify\":0,\"startDelayNotifyPriority\":0,\"startDelayOperation\":0,\"startDelayOperationEndStatus\":2,\"startDelayOperationEndValue\":-1,\"startDelayOperationType\":4,\"startDelaySession\":0,\"startDelaySessionValue\":1,\"startDelayTime\":0,\"startDelayTimeValue\":null,\"suspend\":0},\"warnPriority\":2},\"detail\":null}\");");
			
			JobTreeItemUtil.addChildren(parent, item);
			
			item.getData().setOwnerRoleId(parent.getData().getOwnerRoleId());
			item.getData().setId(detailPage.getJobId());
			item.getData().setJobunitId(parent.getData().getJobunitId());
			item.getData().setName(detailPage.getJobName());
			item.getData().getCommand().setFacilityID(facilities.get(0));
			
			Option o = new Option();
			o.setName("deviceName");
			o.setValue(instancePage.getDevice());
			
			String command = endpoint.makeAttachStorageCommand(storage.getCloudScope().getId(), storage.getLocation().getId(), instancePage.getInstance().getId(), storage.getId(), Arrays.asList(o));
			item.getData().getCommand().setStartCommand(command);
			
			IHinemosManager manager = storage.getHinemosManager();
			JobEndpointWrapper wrapper = JobEndpointWrapper.getWrapper(manager.getManagerName());
			
			wrapper.registerJobunit(JobUtil.getTopJobUnitTreeItem(parent));
			JobEditState jobEditState = JobEditStateUtil.getJobEditState(manager.getManagerName());
			jobEditState.updateJobTree(ownerRoleId, false);
			
			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
				null,
				Messages.getString("successful"),
				CloudConstants.bundle_messages.getString("message.finish.job.regist"));
			
			return true;
		} catch (Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);

			String message = e.getMessage();
			if (message == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos, true);
				e.printStackTrace(ps);
				
				message = bos.toString();
			}
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), message);
			return false;
		}
	}
	
	protected JobTreeItem getTopJobTreeItem(JobTreeItem item) {
		if (item.getParent() != null)
			return item.getParent();
		return item;
	}

	protected JobTreeItem findJobTreeItem(JobTreeItem item, String jobUnitId, String jobId) {
		if (item.getData().getJobunitId().equals(jobUnitId) && item.getData().getId().equals(jobId)) {
			return item;
		}
		for (JobTreeItem child: item.getChildren()) {
			JobTreeItem matched = findJobTreeItem(child, jobUnitId, jobId);
			if (matched != null)
				return matched;
		}
		return null;
	}
	
	@Override
	public void setContainer(IWizardContainer wizardContainer) {
		super.setContainer(wizardContainer);
		if (wizardContainer instanceof WizardDialog) {
			((WizardDialog)wizardContainer).addPageChangedListener(new IPageChangedListener() {
				@Override
				public void pageChanged(PageChangedEvent event) {
					Object nextPage = event.getSelectedPage();
					if (nextPage instanceof JobDetailPage && !firstShowDetail) {
						JobTreePage jobTreePage = (JobTreePage)getPage(JobTreePage.pageName);
						JobTreeItem parent =jobTreePage.getSelectedItem();

						JobTreeItem top = getTopJobTreeItem(parent);
						
						int count = 0;
						String jobIdOrigine = String.format("%s_%s_%s_s-attach", storage.getCloudScope().getId(), storage.getLocation().getId(), storage.getId());
						String jobId = jobIdOrigine;
						while (true) {
							JobTreeItem matched = findJobTreeItem(top, parent.getData().getJobunitId(), jobId);
							if (matched == null)
								break;
							jobId = jobIdOrigine + "-" + ++count;
						}
						
						JobDetailPage detailPage = (JobDetailPage)nextPage;
						detailPage.setJobId(jobId);
						detailPage.setJobName(jobId);
						
						firstShowDetail = true;
					}
				}
			});
		}
	}
	
	public String getJobName() {
		JobDetailPage page = (JobDetailPage)getPage(JobDetailPage.pageName);
		return page.getJobName();
	}
	
	public String getJobId() {
		JobDetailPage page = (JobDetailPage)getPage(JobDetailPage.pageName);
		return page.getJobId();
	}
	
	public JobTreeItem getJobTreeItem() {
		JobTreePage page = (JobTreePage)getPage(JobTreePage.pageName);
		return page.getSelectedItem();
	}
	
	public FacilityTreeItem getFacilityTreeItem() {
		FacilityTreePage page = (FacilityTreePage)getPage(FacilityTreePage.pageName);
		return page.getSelectedItem();
	}
}