package com.clustercontrol.xcloud.aws.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.Instance;
import com.clustercontrol.ws.xcloud.Option;
import com.clustercontrol.xcloud.aws.ui.dialogs.AttachStorageDialog;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.IStorage;

public class AttachStorageHandler implements ICloudOptionHandler, CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IStorage storage = (IStorage)selection.getFirstElement();
		
		AttachStorageDialog dialog = new AttachStorageDialog(HandlerUtil.getActiveShell(event), storage);
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			Instance selectedInstance = dialog.getInstance();
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				MessageFormat.format(msgConfirmAttachStorage,
						selectedInstance.getName(), selectedInstance.getId(),
						storage.getName(), storage.getId()
						))) {
				
				try {
					CloudEndpoint endpoint = storage.getLocation().getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
					
					Option option = new Option();
					option.setName("deviceName");
					option.setValue(dialog.getDeviceName());
					
					endpoint.attachStorage(
							storage.getLocation().getCloudScope().getId(),
							storage.getLocation().getId(),
							selectedInstance.getId(),
							storage.getId(),
							Arrays.asList(option));
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishAttachStorage,
								selectedInstance.getName(), selectedInstance.getId(),
								storage.getName(), storage.getId()));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							storage.getLocation().getComputeResources().updateStorages();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}
