package com.clustercontrol.xcloud.aws.ui.handlers;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_associateaPublicIpAddress;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_deleteOnTermination;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_disableApiTermination;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_ebsOptimized;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_instanceInitiatedShutdownBehavior;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_instanceType;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_iops;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_keyName;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_monitoring;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_securityGroupIds;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_subnetId;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_volumeSize;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_volumeType;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.BackupedData;
import com.clustercontrol.ws.xcloud.BackupedDataEntry;
import com.clustercontrol.ws.xcloud.CloneBackupedInstanceRequest;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.Tag;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.aws.ui.dialogs.AWSResourceProvider;
import com.clustercontrol.xcloud.aws.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.xcloud.aws.ui.dialogs.CreateInstanceDialog.DialogData;
import com.clustercontrol.xcloud.common.CloudConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.IBackupedDataEntry;
import com.clustercontrol.xcloud.model.cloud.IInstanceBackupEntry;
import com.clustercontrol.xcloud.model.cloud.ILocation;
import com.clustercontrol.xcloud.plugin.CloudOptionSourceProvider;
import com.clustercontrol.xcloud.util.CollectionComparator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;

public class CloneBackupedInstanceHandler implements ICloudOptionHandler, CloudStringConstants, AWSStringConstants {
	@Override
	public Object execute(ExecutionEvent event) {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IInstanceBackupEntry backupedEntry = (IInstanceBackupEntry)selection.getFirstElement();
		final ILocation location = (ILocation)HandlerUtil.getVariable(event, CloudOptionSourceProvider.ActiveLocation);
		final CloneBackupedInstanceRequest request = new CloneBackupedInstanceRequest();
		
		request.setInstanceId(backupedEntry.getBackup().getInstance().getId());
		request.setInstanceSnapshotId(backupedEntry.getId());
		request.setModifiedData(new BackupedData());
		
		for (IBackupedDataEntry entry: backupedEntry.getBackupedDataEntries()) {
			BackupedDataEntry e = new BackupedDataEntry();
			e.setName(entry.getName());
			e.setValue(entry.getValue());
			request.getModifiedData().getEntries().add(e);
		}
		
		final Map<String, String> dataMap = new HashMap<>();
		for (BackupedDataEntry entry: request.getModifiedData().getEntries()) {
			dataMap.put(entry.getName(), entry.getValue());
		}
		CreateInstanceDialog dialog = new CreateInstanceDialog(
				HandlerUtil.getActiveShell(event),
				location,
				MessageFormat.format(dlgComputeHistryClone, strAws),
				new AWSResourceProvider(location)) {
			@Override
			protected Control createDialogArea(Composite parent) {
				Control control = super.createDialogArea(parent);
				txtAmiId.setEnabled(false);
				return control;
			}
		};
		dialog.setDialogData(new DialogData() {
			@Override
			public String getName() {
				return dataMap.get(CloudConstants.backup_instanceName);
			}
			@Override
			public void setName(String value) {
				dataMap.put(CloudConstants.backup_instanceName, value);
			}
			@Override
			public String getMemo() {
				return dataMap.get(CloudConstants.backup_memo);
			}
			@Override
			public void setMemo(String value) {
				dataMap.put(CloudConstants.backup_memo, value);
			}
			@Override
			public List<Tag> getTags() {
				String tagsString = dataMap.get(CloudConstants.backup_tags);
				if (tagsString == null)
					return Collections.emptyList();
				ObjectMapper om = new ObjectMapper();
				ObjectReader or = om.reader(new TypeReference<List<Tag>>(){});
				try {
					return or.readValue(tagsString);
				} catch (IOException e) {
					return Collections.emptyList();
				}
			}
			@Override
			public void setTags(List<Tag> value) {
				try {
					ObjectMapper om = new ObjectMapper();
					ObjectWriter ow = om.writerFor(new TypeReference<List<Tag>>(){});
					dataMap.put(CloudConstants.backup_tags, ow.writeValueAsString(value));
				} catch (IOException e) {
					dataMap.put(CloudConstants.backup_tags, null);
				}
			}
			@Override
			public Boolean isAssociatePublicIpAddress() {
				return Boolean.valueOf(dataMap.get(backup_aws_associateaPublicIpAddress));
			}
			@Override
			public void setAssociatePublicIpAddress(Boolean value) {
				dataMap.put(backup_aws_associateaPublicIpAddress, value == null ? Boolean.FALSE.toString(): Boolean.toString(value));
			}
			@Override
			public Boolean isDisableApiTermination() {
				return Boolean.valueOf(dataMap.get(backup_aws_disableApiTermination));
			}
			@Override
			public void setDisableApiTermination(Boolean value) {
				dataMap.put(backup_aws_disableApiTermination, value == null ? Boolean.FALSE.toString(): Boolean.toString(value));
			}
			@Override
			public Boolean isEbsOptimized() {
				return Boolean.valueOf(dataMap.get(backup_aws_ebsOptimized));
			}
			@Override
			public void setEbsOptimized(Boolean value) {
				dataMap.put(backup_aws_ebsOptimized, value == null ? Boolean.FALSE.toString(): Boolean.toString(value));
			}
			@Override
			public String getImageId() {
				return request.getInstanceSnapshotId();
			}
			@Override
			public void setImageId(String value) {
			}
			@Override
			public String getInstanceInitiatedShutdownBehavior() {
				return dataMap.get(backup_aws_instanceInitiatedShutdownBehavior);
			}
			@Override
			public void setInstanceInitiatedShutdownBehavior(String value) {
				dataMap.put(backup_aws_instanceInitiatedShutdownBehavior, value);
			}
			@Override
			public String getInstanceType() {
				return dataMap.get(backup_aws_instanceType);
			}
			@Override
			public void setInstanceType(String value) {
				dataMap.put(backup_aws_instanceType, value);
			}
			@Override
			public String getKeyName() {
				return dataMap.get(backup_aws_keyName);
			}
			@Override
			public void setKeyName(String value) {
				dataMap.put(backup_aws_keyName, value);
			}
			@Override
			public Boolean isMonitoring() {
				return Boolean.valueOf(dataMap.get(backup_aws_monitoring));
			}
			@Override
			public void setMonitoring(Boolean value) {
				dataMap.put(backup_aws_monitoring, value == null ? Boolean.FALSE.toString(): Boolean.toString(value));
			}
			@Override
			public Boolean isDeleteOnTermination() {
				return Boolean.valueOf(dataMap.get(backup_aws_deleteOnTermination));
			}
			@Override
			public void setDeleteOnTermination(Boolean value) {
				dataMap.put(backup_aws_deleteOnTermination, value == null ? Boolean.FALSE.toString(): Boolean.toString(value));
			}
			@Override
			public Integer getIops() {
				String iopsString = dataMap.get(backup_aws_iops);
				return iopsString != null ? Integer.valueOf(iopsString): null;
			}
			@Override
			public void setIops(Integer value) {
				dataMap.put(backup_aws_iops, value == null ? Integer.toString(0): Integer.toString(value));
			}
			@Override
			public Integer getVolumeSize() {
				String sizeString = dataMap.get(backup_aws_volumeSize);
				return sizeString != null ? Integer.valueOf(sizeString): null;
			}
			@Override
			public void setVolumeSize(Integer value) {
				dataMap.put(backup_aws_volumeSize, value == null ? Integer.toString(0): Integer.toString(value));
			}
			@Override
			public String getVolumeType() {
				return dataMap.get(backup_aws_volumeType);
			}
			@Override
			public void setVolumeType(String value) {
				dataMap.put(backup_aws_volumeType, value);
			}
			@Override
			public List<String> getSecurityGroupIds() {
				String securityGroupIds = dataMap.get(backup_aws_securityGroupIds);
				if (securityGroupIds == null)
					return Collections.emptyList();
				ObjectMapper om = new ObjectMapper();
				ObjectReader or = om.reader(new TypeReference<List<String>>(){});
				try {
					return or.readValue(securityGroupIds);
				} catch (IOException e) {
					return Collections.emptyList();
				}
			}
			@Override
			public void setSecurityGroupIds(List<String> value) {
				try {
					ObjectMapper om = new ObjectMapper();
					ObjectWriter ow = om.writerFor(new TypeReference<List<String>>(){});
					dataMap.put(backup_aws_securityGroupIds, ow.writeValueAsString(value));
				} catch (IOException e) {
					dataMap.put(backup_aws_securityGroupIds, null);
				}
			}
			@Override
			public String getSubnetId() {
				return dataMap.get(backup_aws_subnetId);
			}
			@Override
			public void setSubnetId(String value) {
				dataMap.put(backup_aws_subnetId, value);
			}
		});
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			String instanceName = dataMap.get(CloudConstants.backup_instanceName);
			instanceName = instanceName == null ? "": instanceName;
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				MessageFormat.format(msgConfirmCloneComputeSnapshot, backupedEntry.getName(), backupedEntry.getId(), instanceName))) {
				
				try {
					CollectionComparator.compareCollection(request.getModifiedData().getEntries(), dataMap.entrySet(), new CollectionComparator.Comparator<BackupedDataEntry, Map.Entry<String, String>>(){
						@Override
						public boolean match(BackupedDataEntry o1, Entry<String, String> o2) {
							return o1.getName().equals(o2.getKey());
						}
						@Override
						public void matched(BackupedDataEntry o1, Entry<String, String> o2) {
							o1.setValue(o2.getValue());
						}
						@Override
						public void afterO1(BackupedDataEntry o1) {
							request.getModifiedData().getEntries().remove(o1);
						}
						@Override
						public void afterO2(Entry<String, String> o2) {
							BackupedDataEntry entry = new BackupedDataEntry();
							entry.setName(o2.getKey());
							entry.setValue(o2.getValue());
							request.getModifiedData().getEntries().add(entry);
						}
						
					});
					
					CloudEndpoint endpoint = location.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
					endpoint.cloneBackupedInstance(location.getCloudScope().getId(), location.getId(), request);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishCloneComputeSnapshot, instanceName));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							location.updateLocation();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}
