var URLBASE = "http://152.254.4.77:8083/api/books?pageno=@pageno@&perpage=20";
var DETAILURL = "http://152.254.4.77:8083/api/books/@isbn@";
var IMGURL = "http://152.254.4.77:8083/resource/book/";

///// Initialize top page
function initTopPage() {
    loadData(1);
}

function loadData(pageno) {
    var url = URLBASE.replace("@pageno@",String(pageno));
    $.ajax({
        async: true,
        dataType: 'json',
        url: url,
        success: function (result, status) {
            $(".divider").remove();
            var data = result.items;
            //$("#List").empty();
            for (var i=0;i<data.length;i++) {
                $li = $("<li><a href='#' class='show'><img></img><h3 class='title'></h3><p class='code'></p></a><a href='#' class='detail' >detail</a></li>");
                $li.find("img").attr("src",IMGURL + data[i].ISBN + '_m.jpg');
                $li.find("h3").text(data[i].TITLEKJ);
                $li.find("p").text(data[i].ISBN);
                $(".detail",$li).click(onDetailLink);
                $("#List").append($li);
            }
            if (result.pageno < result.maxpage) {
                $divide = $("<li data-role='list-divider' class='divider' ><a id='more' onClick='loadData(" + String(result.pageno+1) + ")'>もっと見る</a></li>");
                $("#List").append($divide);
            }
            $("#List").listview("refresh");
        }
    })
    .error(function (jqXHR, textStatus, errorThrown) {
        alert(jqXHR.status);
    })
    .complete(function () {
    });
}

///// Move to detail page
function onDetailLink() {
    var $li = $(this).parent();
    var isbn = $li.find(".code").text();
    var imgurl = IMGURL + isbn + "_l.jpg";
    var url = DETAILURL.replace("@isbn@",String(isbn));
    $.ajax({
        async: true,
        dataType: 'json',
        url: url,
        success: function (result, status) {
            $("#DetailPage h1").text(result[0].TITLEKJ);
            $("#DetailPage #isbn").text(isbn);
            $("#DetailPage #titlekj").html(result[0].TITLEKJ);
            $("#DetailPage #titlekn").html(result[0].TITLEKN);
            $("#DetailPage #author").html(result[0].AUTHOR);
            $("#DetailPage #publisher").html(result[0].PUBLISHER);
            $("#DetailPage #salesdt").html(result[0].SALESDT);
            $("#DetailPage #price").html(result[0].PRICE);
            $("#DetailPage img").attr("src",imgurl);
            $.mobile.changePage("#DetailPage");
        }
    })
    .error(function (jqXHR, textStatus, errorThrown) {
        alert(jqXHR.status);
    })
    .complete(function () {
    });
}

///// Called when app launch
function onReady() {
    initTopPage();
    monaca.splashScreen.hide();
}

$(onReady); // on DOMContentLoaded

