//
//  HMXSPFComponent.h
//  HMXSPFComponent
//
//  Created by Hori,Masaki on 08/08/29.
//  Copyright 2008 masakih. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface HMXSPFComponent : NSObject <NSCoding>
{
	NSString *title;
	BOOL isSelected;
	NSIndexPath *selectionIndexPath;
	
	HMXSPFComponent *parent;	// not retained.
}

+ (id)xspfPlaylist;
+ (id)xspfTrackList;
+ (id)xspfTrackWithLocation:(NSURL *)location;
+ (id)xspfComponentWithXMLElementString:(NSString *)string error:(NSError **)outError;

+ (id)xspfComponemtWithXMLElement:(NSXMLElement *)element;
- (id)initWithXMLElement:(NSXMLElement *)element; // abstract.

- (NSXMLElement *)XMLElement; // abstract.

- (NSURL *)movieLocation;

- (void)setTitle:(NSString *)title;
- (NSString *)title;

- (void)setDuration:(NSDate *)duration;
- (NSDate *)duration;
@end

@interface HMXSPFComponent (XspfComponentSelection)
// selection for playing.
- (BOOL)isSelected;
- (void)select;
- (void)deselect;
- (void)setSelectionIndex:(NSUInteger)index;
- (NSUInteger)selectionIndex;
- (BOOL)setSelectionIndexPath:(NSIndexPath *)indexPath;
- (NSIndexPath *)selectionIndexPath;

- (void)setIsPlayed:(BOOL)state;
- (BOOL)isPlayed;

- (HMXSPFComponent *)currentTrack;	// default self;
- (void)next;						// abstract.
- (void)previous;					// abstract.

- (void)setCurrentTrackDuration:(NSDate *)duration;
- (NSDate *)currentTrackDuration;

@end

@interface HMXSPFComponent(XspfConainerComponent)
- (HMXSPFComponent *)parent;
- (NSArray *)children;		// default nil.
- (NSUInteger)childrenCount;	// default [[self children] count].
- (NSUInteger)indexOfChild:(HMXSPFComponent *)child;	// default [[self children] indexOfObject:].
- (HMXSPFComponent *)childAtIndex:(NSUInteger)index;	// default [[self children] objectAtIndex:].
- (BOOL)isLeaf;				// default YES.

- (void)addChild:(HMXSPFComponent *)child;	// not implemented.
- (void)removeChild:(HMXSPFComponent *)child;	// not implemented.
- (void)insertChild:(HMXSPFComponent *)child atIndex:(NSUInteger)index;	// not implemented.
- (void)removeChildAtIndex:(NSUInteger)index;	//not implemented.
- (void)moveChildFromIndex:(NSUInteger)from toIndex:(NSUInteger)to;	//not implemented.
- (void)setParent:(HMXSPFComponent *)parent;	// Do not call directly. call in only -addChild: method.
@end

@interface HMXSPFComponent(XspfThumbnailSupport)
- (void)setThumbnailTrackNum:(NSUInteger)trackNum timeIntarval:(NSTimeInterval)timeIntarval;
- (void)setThumbnailComponent:(HMXSPFComponent *)item timeIntarval:(NSTimeInterval)timeIntarval;
- (HMXSPFComponent *)thumbnailTrack;
- (NSTimeInterval)thumbnailTimeInterval;
- (void)removeThumbnailFrame;
@end

extern NSString *XspfQTXMLTrackElementName;
extern NSString *XspfQTXMLTrackListElementName;
extern NSString *XspfQTXMLPlaylistElementName;
extern NSString *XspfQTXMLTitleElementName;
extern NSString *XspfQTXMLLocationElementName;
extern NSString *XspfQTXMLDurationElementName;

extern NSString *XspfQTXMLExtensionElementName;
extern NSString *XspfQTXMLApplicationAttributeName;


extern NSString *XspfQTXMLNamespaceseURI;
extern NSString *XspfQTXMLNamespacesePrefix;
extern NSString *XspfQTXMLAliasElement;
extern NSString *XspfQTXMLThumbnailElementName;
extern NSString	*XspfQTXMLThumbnailTrackNumAttributeName;
extern NSString	*XspfQTXMLThumbnailTimeAttributeName;

