//
//  NSURL-HMExtensions.m
//
//  Created by Hori,Masaki on 09/03/15.
//  Copyright 2009 masakih. All rights reserved.
//

#import "NSURL-HMExtensions.h"


@implementation NSURL (HMCocoaExtention)

- (BOOL)isEqualUsingLocalhost:(NSURL *)other
{
	if([self isEqual:other]) return YES;
	if(!other) return NO;
	
	NSString *myHost = [self host];
	NSString *otherHost = [other host];
	if((!myHost && [otherHost isEqualToString:@"localhost"])
		|| (!otherHost && [myHost isEqualToString:@"localhost"])) {
		NSString *myPath = [self path];
		NSString *otherPath = [other path];
		if([myPath isEqualToString:otherPath]) return YES;
	}
	
	return NO;
}
@end
