DROP TABLE IF EXISTS Host;
CREATE TABLE Host (
 hostOID     integer  AUTO_INCREMENT NOT NULL,
 updateDate  TIMESTAMP NOT NULL,
 registDate  TIMESTAMP NOT NULL,
 hostname    VARCHAR(255) NOT NULL,
 ip          VARCHAR(15) NOT NULL,
 mac         VARCHAR(17) NOT NULL,
 hostComment VARCHAR(255)   DEFAULT "",
 status      VARCHAR(255)   DEFAULT "unknown",
 PRIMARY KEY (hostOID) ) ;

CREATE UNIQUE INDEX IDX_Host3 ON Host (
	mac
);
CREATE UNIQUE INDEX IDX_Host2 ON Host (
	ip
);
CREATE UNIQUE INDEX IDX_Host1 ON Host (
	hostname
);
DROP TABLE IF EXISTS Timer;
CREATE TABLE Timer (
 timerOID         integer  AUTO_INCREMENT NOT NULL,
 updateDate       TIMESTAMP NOT NULL,
 registDate       TIMESTAMP NOT NULL,
 hostOID          INTEGER NOT NULL,
 timerName        VARCHAR(255) NOT NULL,
 enableFlg        TINYINT   DEFAULT 1.0 NOT NULL,
 triggerDT        TIMESTAMP NOT NULL,
 triggerDayOfWeek CHAR(8)   DEFAULT "00000000" NOT NULL,
 triggerEvery     INTEGER   DEFAULT 1.0 NOT NULL,
 triggerOID       INTEGER NOT NULL,
 PRIMARY KEY (timerOID) ) ;

CREATE  INDEX IDX_Timer1 ON Timer (
	hostOID
);
CREATE UNIQUE INDEX IDX_Timer2 ON Timer (
	timerName
);
DROP TABLE IF EXISTS Trigger;
CREATE TABLE Trigger (
 triggerOID       integer  AUTO_INCREMENT NOT NULL,
 updateDate       TIMESTAMP NOT NULL,
 registDate       TIMESTAMP NOT NULL,
 triggerClass     VARCHAR(255) NOT NULL,
 triggerName      VARCHAR(255) NOT NULL,
 triggerDispOrder INTEGER NOT NULL,
 PRIMARY KEY (triggerOID) ) ;

CREATE UNIQUE INDEX IDX_Trigger2 ON Trigger (
	triggerName
);
CREATE UNIQUE INDEX IDX_Trigger1 ON Trigger (
	triggerClass
);
DROP TABLE IF EXISTS MailAddr;
CREATE TABLE MailAddr (
 mailAddrOID INTEGER NOT NULL,
 updateDate  TIMESTAMP NOT NULL,
 registDate  TIMESTAMP NOT NULL,
 mailAddress VARCHAR(255) NOT NULL,
 PRIMARY KEY (mailAddrOID) ) ;

CREATE UNIQUE INDEX IDX_MailAddr1 ON MailAddr (
	mailAddrOID
);
