/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    fobOx  fBXpb`tbN                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__dsp_hok_h__
#define __HOS_V4__dsp_hok_h__



/* fBXpb`tbN}N */
#ifdef _HOS_DSP_HOK_ENABLE
#ifndef _HOS_TSW_HOK_ENABLE
#define _HOS_TSW_HOK_ENABLE
#endif
#ifndef _HOS_INT_HOK_ENABLE
#define _HOS_INT_HOK_ENABLE
#endif
#endif

/* ^XNXCb` tbN}N̒` */
#ifdef _HOS_TSW_HOK_ENABLE
#define _HOS_TSW_HOK()	_hos_tsw_hok()	/* L */
#else
#define _HOS_TSW_HOK()					/*  */
#endif

/* 荞 tbN}N̒` */
#ifdef _HOS_INT_HOK_ENABLE
#define _HOS_INTSTA_HOK(intno)	_hos_intsta_hok(intno)	/* L */
#define _HOS_INTEXT_HOK(intno)	_hos_intext_hok(intno)
#else
#define _HOS_INTSTA_HOK(intno)							/*  */
#define _HOS_INTEXT_HOK(intno)
#endif

/* fBXpb`^Cv` */
#define _HOS_DSPTYPE_TSKSWC		1	/* ^XNXCb` */
#define _HOS_DSPTYPE_STAINT		2	/* 荞ݏJn */
#define _HOS_DSPTYPE_EXTINT		3	/* 荞ݏI */

/* tbN}XN */
#define _HOS_HOKMSK_TSW			0x01	/* ^XNXCb`tbN */
#define _HOS_HOKMSK_INT			0x02	/* 荞݃tbN */


/* fBXpb` */
typedef struct t_dbg_dspinf
{
	UW  time;		/*  */
	INT type;		/*  */
	INT id;			/* ID */
} T_DBG_DSPINF;



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ֐ */
void _hosdbg_ini_dsphok(T_DBG_DSPINF dspinf[], INT infcnt);	/* tbN */
void _hosdbg_sta_dsphok(INT mask);							/* tbNJn */
void _hosdbg_stp_dsphok(void);								/* tbN~ */

/* Oǂݏo֐ */
T_DBG_DSPINF *_hosdbg_red_fst(void);		/* ǂݏoJn */
T_DBG_DSPINF *_hosdbg_red_nxt(void);		/* ǂݏo */

/* fBXpb`tbN֐ */
void _hos_tsw_hok(void);			/* ^XNXCb` tbN */
void _hos_intsta_hok(INTNO intno);	/* 荞݊Jn tbN */
void _hos_intext_hok(INTNO intno);	/* 荞ݏI tbN */

/* [U[쐬֐ */
UW   _hosdbg_get_tim(void);			/* xԎ擾 */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__dsp_hok_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
