/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    vZbTۉR|[lg ( H8/300H p)                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */



#ifndef __HOS_V4__H83__hospac_h__
#define __HOS_V4__H83__hospac_h__



#include "itron.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* 荞݃}XN` */
#define H83_IMSK_I_BIT		0x80	/* 荞݃}XNrbg */
#define H83_IMSK_UI_BIT		0x40	/* [U[rbg^荞݃}XNrbg */

#define H83_IMSK_LEVEL0		0x00								/* vCIeB[x0/1 */
#define H83_IMSK_LEVEL1		(H83_IMSK_I_BIT)					/* vCIeB[x1̂݋ */
#define H83_IMSK_LEVEL2		(H83_IMSK_I_BIT | H83_IMSK_UI_BIT)	/* ׂċ֎~ */



/* ------------------------------------------ */
/*                   ^`                   */
/* ------------------------------------------ */

typedef UB	IMSK;		/* 荞݃}XN */


/* ReLXgۑubN */
typedef struct t_hos_pac_ctxinf
{
	VP sp;
} T_HOSPAC_CTXINF;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

extern UB kernel_h83_imsk;		/* 荞݃}XNl */
extern UB kernel_h83_ibmsk;		/* 荞݃x[X}XNl */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

void hospac_ini_sys(void);			/* VXȅ */

void hospac_dis_int(void);			/* 荞݋֎~ */
void hospac_ena_int(void);			/* 荞݋ */

#if ( __CPU__ == 2 ) /* HC H8/300HN */
void hospac_cre_ctx_asm(T_HOSPAC_CTXINF *pk_ctxinf,
					FP task, VP sp, VP_INT exinf);			/* sReLXg̍쐬(AZup) */
#define hospac_cre_ctx(pk_ctxinf, exinf, task, stksz, stk)	\
	hospac_cre_ctx_asm(pk_ctxinf, task, ((VP)((UB *)(stk) + ((stksz) & 0xfffffffc))), exinf)
#else				/* HC H8/300H or GCC */
void hospac_cre_ctx_asm(T_HOSPAC_CTXINF *pk_ctxinf,
					VP sp, FP task, VP_INT exinf);			/* sReLXg̍쐬(AZup) */
#define hospac_cre_ctx(pk_ctxinf, exinf, task, stksz, stk)	\
	hospac_cre_ctx_asm(pk_ctxinf, ((VP)((UB *)(stk) + ((stksz) & 0xfffffffc))), task, exinf)
#endif
	/* AZuœs悤Ɉւ */
#define hospac_del_ctx(pk_ctxinf)	do {} while (0)			/* sReLXg̍폜(sv) */
void hospac_swi_ctx(T_HOSPAC_CTXINF *pk_nxt_ctxinf,
					T_HOSPAC_CTXINF *pk_pre_ctxinf);	/* sReLXǧ */
void hospac_chg_ctx(T_HOSPAC_CTXINF *pk_nxt_ctxinf);	/* sReLXgύX */
#define hospac_idle()	do {} while (0)						/* ACh̓(Ȃ) */


ER chg_imsk(IMSK imsk);				/* 荞݃}XÑx[Xl̕ύX */
ER get_imsk(IMSK *p_imsk);			/* 荞݃}XÑx[Xl̎Q */

ER fchg_imsk(IMSK imsk);			/* ݂̊݃}XNl̋ύX */
ER fget_imsk(IMSK *p_imsk);			/* ݂̊݃}XNl̋Q */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__H83__hospac_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
