/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    vZbTۉR|[lg(IA32p)                                */
/*    fBXNv^`                                                    */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */
#ifndef __HOS_V4__IA32__descriptor_h__
#define __HOS_V4__IA32__descriptor_h__

/* ZOg  */
#define KERNEL_CS    0x8    /*  J[lR[hZOg  */
#define KERNEL_DS   0x10    /*  J[l[UZOg  */
#define SYS_PRIV       0    /*  VXe  */
#define MAX_SELECTOR   3    /*  ZOg  */
#define MAX_INTR     256    /*  O//gbv̑  */

/* 
 * fBXNv^[e[u
 * GDTR/IDTR
 */
typedef struct _descriptor_tbl{
  unsigned limit:16;
  unsigned base:32 __attribute__ ((packed));
}descriptor_tbl_t;
/*
 *  ZOg fBXNv^
 *  IA32VXevO~OKCh 3-11y[Wȍ~Q
 */
typedef struct _segment_desc{
  /* ZOgE~bg 15:00  */
  unsigned	limit_low:16;
  /*  x[XEAhX  23:00(pbNȂƐ؂邱Ƃɒ)  */
  unsigned	base_low:24;
  /*  ^Cv  */
  unsigned	type:4;
  /*  fBXNv^E^Cv 0=VXeZOg 1=R[hEf[^  */
  unsigned	s:1;
  /*  fBXNv^x  */
  unsigned	dpl:2;
  /*  ZOg݃rbg  */
  unsigned	p:1;
  /*  ZOgE~bg 19:16  */
  unsigned	limit_high:4;
  /*  OSŎgptB[h  */
  unsigned	avl:1;
  /*  \rbg(0łȂ΂ȂȂ)  */
  unsigned	reserved:1;
  /*  Iy[VTCY 0=16rbg, 1=32rbg */
  unsigned	db:1;
  /*  x(OjeB)rbg  1=y[WP, 0=oCgP  */
  unsigned	g:1;
  /*  x[XEAhX  31:24  */
  unsigned	base_high:8;
} __attribute__ ((packed)) segment_desc_t;
/*
 *  Q[g fBXNv^
 *  IA32VXevO~OKCh 3-17y[W, 5-14y[W
 */
/*  gate descriptor  */
typedef struct _gate_desc{
  /*  ItZbg̉ʃ[h(15:00) */
  unsigned	offset_low:16;
  /*  ZOgEZN^  */
  unsigned	selector:16;
  /*  Rs[JEg  */
  unsigned	copy_count:8;
  /*  ^Cv  */
  unsigned	type:4;
  /*  \rbg  */
  unsigned	reserved:1;
  /*    */
  unsigned	dpl:2;
  /*  ZOg݃rbg  */
  unsigned	p:1;
  /*  ItZbg̏ʃ[h(31:16)  */
  unsigned	offset_high:16;
}gate_desc_t;
/*
 *  IA32ZOg^Cv  
 */
/*  ǂݎp, ANZX, GLXphAbv f[^ZOg  */
#define _RO_NOACS_XPDUP_DATA_TYPE  0x0  
/*  ǂݎp, ANZX, GLXphAbv f[^ZOg  */
#define _RO_ACSED_XPDUP_DATA_TYPE  0x1
/*  ǂݏ, ANZX, GLXphAbv f[^ZOg  */
#define _RW_NOACS_XPDUP_DATA_TYPE  0x2
/*  ǂݏ, ANZX, GLXphAbv f[^ZOg  */
#define _RW_ACSED_XPDUP_DATA_TYPE  0x3
/*  ǂݎp, ANZX, GLXph_E f[^ZOg  */
#define _RO_NOACS_XPDDW_DATA_TYPE  0x4
/*  ǂݎp, ANZX, GLXph_E f[^ZOg  */
#define _RO_ACSED_XPDDW_DATA_TYPE  0x5
/*  ǂݏ, ANZX, GLXph_E f[^ZOg  */
#define _RW_NOACS_XPDDW_DATA_TYPE  0x6
/*  ǂݏ, ANZX, GLXph_E f[^ZOg  */
#define _RW_ACSED_XPDDW_DATA_TYPE  0x7
/*  sp, ANZX, RtH[~O R[hZOg  */
#define _RO_NOACS_NOCON_CODE_TYPE  0x8
/*  sp, ANZX, RtH[~O R[hZOg  */
#define _RO_ACSED_NOCON_CODE_TYPE  0x9
/*  sEǂݎ, ANZX, RtH[~O R[hZOg  */
#define _RW_NOACS_NOCON_CODE_TYPE  0xa
/*  sEǂݎ, ANZX, RtH[~O R[hZOg  */
#define _RW_ACSED_NOCON_CODE_TYPE  0xb
/*  sp, ANZX, RtH[~O R[hZOg  */
#define _RO_NOACS_CONFM_CODE_TYPE  0xc
/*  sp, ANZX, RtH[~O R[hZOg  */
#define _RO_ACSED_CONFM_CODE_TYPE  0xd
/*  sEǂݎ, ANZX, RtH[~O R[hZOg  */
#define _RW_NOACS_CONFM_CODE_TYPE  0xe
/*  sEǂݎ, ANZX, RtH[~O R[hZOg  */
#define _RW_ACSED_CONFM_CODE_TYPE  0xf
/*
 *  HOS ŗpZOg`
 */
/*  R[hZOg  */
#define CODE_SEG_TYPE  _RW_NOACS_NOCON_CODE_TYPE
/*  f[^ZOg  */
#define DATA_SEG_TYPE  _RW_NOACS_XPDUP_DATA_TYPE
/*  X^bNZOg  */
#define STACK_SEG_TYPE _RW_NOACS_XPDDW_DATA_TYPE

/*
 *  
 */
#define KERNEL_PRIV  0x0
#define USER_PRIV    0x3

/*  Q[g^Cv  */
#define TASK_GATE_TYPE  0x5  /*  ^XNQ[g  */
#define CALL_GATE_TYPE  0xc  /*  R[Q[g  */
#define INTR_GATE_TYPE  0xe  /*  荞݃Q[g  */
#define TRAP_GATE_TYPE  0xf  /*  荞݃Q[g  */

/*  ZOgݒ}N  */
#define _cast_desc(d,item) (((segment_desc_t *)d)->item)
#define define_region(desc, _addr, _limit, _type, _dpl)  do{                  \
  _cast_desc(desc, base_low) = ( ( (unsigned long)_addr ) & (0xffffff) );     \
  _cast_desc(desc, base_high) = ( ( ( (unsigned long)_addr) >> 24) & (0xff) );\
  _cast_desc(desc, limit_low) = ( ((unsigned long)_limit) & (0xffff) );       \
 _cast_desc(desc, limit_high) = ((((unsigned long)_limit) >> (16) ) & (0xf) );\
  _cast_desc(desc, type) = ( ((unsigned char)_type) & (0xf));                 \
  _cast_desc(desc, s) = 1;  /*  R[hEf[^ZOg  */                  \
  _cast_desc(desc, dpl)= ( ( (unsigned char)_dpl )&(0x3));                    \
  _cast_desc(desc, p) = 1;  /* ݂̂Ƃ  */                         \
  _cast_desc(desc, avl)=0;  /*  Ƃ肠g\͖  */                  \
  _cast_desc(desc, reserved)=0;  /*  \rbg  */                           \
  _cast_desc(desc, db) = 1; /*  32rbgZOg  */                        \
  _cast_desc(desc, g) = 1;  /*  32rbgSANZX̂Ńy[WP  */  \
}while(0)

/*
 *  Q[g fBXNv^}N
 *  IA32VXevO~OKCh 3-17y[W, 5-14y[W
 */
/* Q[gݒ}N  */
#define _cast_gate(d, i) (((gate_desc_t *)d)->i)

#define __set_gate(desc, _sel, _offset, _dpl, gtype) do{                     \
  _cast_gate(desc, offset_low)= ((unsigned long)(_offset)) & 0xffff;         \
  _cast_gate(desc, offset_high)= (((unsigned long)(_offset)) >>16)&(0xffff); \
  _cast_gate(desc, selector) = _sel;                                         \
  _cast_gate(desc, copy_count) = 0;                                          \
  _cast_gate(desc, type) = (gtype);                                          \
  _cast_gate(desc, reserved) = 0;                                            \
  _cast_gate(desc, dpl) = _dpl;                                              \
  _cast_gate(desc, p) = 1;                                                   \
  }while(0)

/*  荞݃Q[gݒ  */
#define gate_set_intr_gate(desc, _sel, _offset, _dpl) do{                   \
    __set_gate(desc, _sel, _offset, _dpl, INTR_GATE_TYPE);                  \
}while(0)
/*  gbvQ[gݒ  */
#define gate_set_trap_gate(desc, _sel, _offset, _dpl) do{                   \
    __set_gate(desc, _sel, _offset, _dpl, TRAP_GATE_TYPE);                  \
}while(0)
/*  R[Q[gݒ  */
#define gate_set_call_gate(desc, _sel, _offset, _dpl) do{                   \
    __set_gate(desc, _sel, _offset, _dpl, CALL_GATE_TYPE);                  \
}while(0)

/*  xN^e[u[h  */
#define load_idtr(idtr)  __asm__ __volatile__( \
                      "movl %0, %%eax\n\t" \
                      "lidt (%%eax)\n\t"   \
                      :/* no output  */    \
                      :"g"(&idtr)          \
                      :"%eax")

#endif  /*  __HOS_V4__IA32__descriptor_h__  */
/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
