/* ------------------------------------------------------------------------*/
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    vZbTۉR|[lg (IA32p)                                   */
/*      vZbTۉR|[lgʒ`                                   */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */
#ifndef __HOS_V4__IA32__hospac_h__
#define __HOS_V4__IA32__hospac_h__
#include "pic.h"         /*  ݃Rg[֘A  */
#include "ioport.h"      /*  I/O |[g֘A  */
#include "hosexp.h"      /*  荞ݗO֘A`  */
#include "descriptor.h"  /*  IA32fBXNv^֘A`  */
#include "itron.h"


/* ------------------------------------------ */
/*                   ^`                   */
/* ------------------------------------------ */
/* IA32ŗL 荞݊Ǘ@\ */
typedef UH		IMSK;		/* 荞݃}XNp^[ */

/* ReLXgۑubN */
typedef struct t_hos_pac_ctxinf
{
	VP sp;			/* X^bN|C^ۑ̈ */
} T_HOSPAC_CTXINF;


/* ------------------------------------------ */
/*                }N`                  */
/* ------------------------------------------ */
#define MAX_IRQ_NR  16  /*  O݂̍ő吔  */

/*  ^XNXCb`O  */
#define __hos_pac_ia32_do_task_switch(current_p, next_p) \
	__asm__ __volatile__(                            \
        "pushfl     \n\t"                                \
        "pushl %%ebx\n\t"                                \
        "pushl %%esi\n\t"                                \
        "pushl %%edi\n\t"                                \
        "pushl %%ebp\n\t"                                \
	"pushl $1f\n\t"                                  \
	"movl %%esp, (%0)\n\t" /* update stack val */    \
	"movl (%1), %%esp\n\t" /* get next  */           \
	"ret\n\t"                                        \
        "1:\tpopl %%ebp\n\t"                             \
        "popl %%edi\n\t"                                 \
        "popl %%esi\n\t"                                 \
        "popl %%ebx\n\t"                                 \
        "popfl\n\t"                                      \
	: /* no output */                                \
	: "r" (current_p), "r" (next_p):"memory" )

#define __hos_pac_ia32_do_task_change(next_p) \
	__asm__ __volatile__(                            \
	"movl (%0), %%esp\n\t" /* get next  */           \
	"ret\n\t"                                        \
	: /* no output */                                \
	: "r" (next_p):"memory" )


/*  ReLXgςݍ  */
#define __hos_pac_ia32_prep_ini_stack(spp, start_func,finalizer,arg)  \
	  do{                                                         \
          __asm__ __volatile__("subl $0xc,(%0)\n\t"                   \
                               "movl (%0),%%ecx\n\t"                     \
                               "movl %1,(%%ecx)\n\t"   /* func  */       \
                               "movl %2,4(%%ecx)\n\t"   /* ext_tsk  */   \
                               "movl %3,8(%%ecx)\n\t"   /* arg */        \
                               :/* No input */                           \
			       :"r"(spp),                                \
			        "r"(start_func),"r"(finalizer),"r"(arg)  \
                               :"ecx");                                  \
          }while(0)

#define hospac_del_ctx(pk_ctxinf)	/* sReLXg̍폜 */

/*  ACh 
 *  d͏ጸ̂߂hlt߂𔭍s
 */
#define hospac_idle()	__asm__ __volatile__("hlt\n\t")  

#define hospac_dis_int()  __asm__ __volatile__("cli\n\t")  /* 荞݋֎~ */

#define hospac_ena_int()  __asm__ __volatile__("sti\n\t")  /* 荞݋ */

/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif
extern void hospac_ini_sys(void);  /* vZbTۉR|[lg̏ */

/* sReNXg쐬 */
extern void hospac_cre_ctx(
        T_HOSPAC_CTXINF *pk_ctxinf,  /* ReLXgi[̐擪Ԓn */
        VP_INT          exinf,       /* N */
        FP              task,        /* NԒn */
        SIZE            stksz,       /* X^bNTCY */
        VP              stk          /* X^bN擪Ԓn */
      );

/* sReLXǧ */
extern void hospac_swi_ctx(T_HOSPAC_CTXINF *pk_pre_ctxinf,
			   T_HOSPAC_CTXINF *pk_nxt_ctxinf);
/* sReLXg̕ύX */
extern void hospac_chg_ctx(T_HOSPAC_CTXINF *pk_nxt_ctxinf);


/* IA32ŗL 荞݊Ǘ@\ */
ER   chg_imsk(IMSK imsk);		/* 荞݃}XNw */
ER   get_imsk(IMSK *p_imsk);		/* 荞݃}XN̎Q */

ER   _kernel_ia32__send_eoi(UW irq);	/* 荞݊ʒm */


#ifdef __cplusplus
}
#endif

#endif  /*  __HOS_V4__IA32__hospac_h__  */
/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
