/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRON4.0 Wwb_                                                 */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */



#ifndef __HOS_V4__itron_h__
#define __HOS_V4__itron_h__



/* ------------------------------------ */
/*          f[^^`                */
/* ------------------------------------ */

typedef signed char		B;			/* t8rbg */
typedef signed short	H;			/* t16rbg */
typedef signed long		W;			/* t32rbg */

typedef unsigned char	UB;			/* 8rbg */
typedef unsigned short 	UH;			/* 16rbg */
typedef unsigned long	UW;			/* 32rbg */

typedef signed char		VB;			/* f[^^Cv܂Ȃ8rbg̒l */
typedef signed short	VH;			/* f[^^Cv܂Ȃ16rbg̒l */
typedef signed long		VW;			/* f[^^Cv܂Ȃ32rbg̒l */

typedef void			*VP;		/* f[^^Cv܂Ȃ̂ւ̃|C^ */
typedef void			(*FP)();	/* vŐNԒni|C^j */

typedef signed   int	INT;		/* vZbTɎRȃTCY̕t(16bitȏ) */
typedef unsigned int	UINT;		/* vZbTɎRȃTCY̕(16bitȏ) */

typedef INT		BOOL;		/* ^Ul */

typedef INT		FN;			/* @\R[h */
typedef INT		ER;			/* G[R[h */
typedef INT		ID;			/* IuWFNgIDԍ */
typedef UH		ATR;		/* IuWFNg̑ */
typedef UH		STAT;		/* IuWFNg̏ */
typedef UH		MODE;		/* T[rXR[̓샂[h */
typedef INT		PRI;		/* Dx */
typedef UW		SIZE;		/* ̈̃TCY */
typedef W		TMO;		/* ^CAEgw */
typedef UW		RELTIM;		/* Ύ */

typedef struct t_systim		/* VXe */
{
	UW ltime;				/*  32bit */
	UH utime;				/*  16bit */
} SYSTIM;

typedef long	VP_INT;		/* VP ܂ INT */

typedef ER		ER_BOOL;	/* ER ܂ BOOL */

typedef W		ER_UINT;	/* ER ܂ UINT */

typedef INT		ER_ID;		/* ER ܂ ID */

typedef UH		TEXPTN;		/* ^XNOṽp^[ */

typedef UH		FLGPTN;		/* tOp^[ */

typedef INT     EXCNO;		/* CPUOnhԍ */

typedef INT		INHNO;		/* 荞݃nhԍ */
typedef INT		INTNO;		/* 荞ݔԍ */



/* ------------------------------------ */
/*             萔`                 */
/* ------------------------------------ */

/*  */
#ifdef NULL		/* CWwb_Ƃ̋ */
#undef NULL
#endif

#ifdef __cplusplus
#define NULL		0			/* |C^ */
#else
#define NULL		((void *)0)	/* |C^ */
#endif

#define TRUE		1			/* ^ */
#define FALSE		0			/* U */
#define E_OK		0			/* I */


/* IuWFNg */
#define TA_NULL		0			/* IuWFNgw肵Ȃ */
#define TA_HLNG		0x00		/* p̃C^[tF[XŏPʂN */
#define TA_ASM		0x01		/* AZup̃C^[tF[XŏPʂN */

#define TA_TFIFO	0x00		/* ^XN̑҂sFIFO */
#define TA_TPRI		0x01		/* ^XN̑҂s^XN̗Dx */

#define TA_MFIFO	0x00		/* bZ[W̑҂sFIFO */
#define TA_MPRI		0x02		/* bZ[W̑҂sbZ[W̗Dx */

#define TA_ACT		0x02		/* ^XNNꂽԂŐ */
#define TA_RSTR		0x04		/* ^XN */

#define TA_WSGL		0x00		/* CxgtO𕡐̃^XN҂ƂȂ */
#define TA_WMUL		0x02		/* CxgtO𕡐̃^XN҂Ƃ */
#define TA_CLR		0x04		/* ҂ɃCxgtONA */

#define TA_INHERIT	0x02		/* ~[ebNXDxpvgRT|[g */
#define TA_CEILING	0x03		/* ~[ebNXDxvgRT|[g */

#define TA_STA		0x02		/* nh𓮍삵ĂԂŐ */
#define TA_PHS		0x04		/* nḧʑۑ */


/* ^CAEgw */
#define TMO_POL		0			/* |[O */
#define TMO_FEVR	(-1)		/* iv҂ */
#define TMO_NBLK	(-2)		/* mubLO */


/* T[rXR[̓샂[h */
#define TWF_ANDW	0x00		/* CxgtOAND҂ */
#define TWF_ORW		0x01		/* CxgtOOR҂ */


/* IuWFNg̏ */
#define TTS_RUN		0x01		/* s */
#define TTS_RDY		0x02		/* s\ */
#define TTS_WAI		0x04		/* ҂ */
#define TTS_SUS		0x08		/* ҂ */
#define TTS_WAS		0x0c		/* d҂ */
#define TTS_DMT		0x10		/* x~ */

#define TTW_SLP		0x0001		/* N҂ */
#define TTW_DLY		0x0002		/* Ԍoߑ҂ */
#define TTW_SEM		0x0004		/* Z}tH̊l҂ */
#define TTW_FLG		0x0008		/* CxgtO҂ */
#define TTW_SDTQ	0x0010		/* f[^L[ւ̑M҂ */
#define TTW_RDTQ	0x0020		/* f[^L[̎M҂ */
#define TTW_MBX		0x0040		/* [{bNX̎M҂ */
#define TTW_MTX		0x0080		/* ~[ebNX̃bN҂ */
#define TTW_SMBF	0x0100		/* bZ[Wobt@ւ̑M҂ */
#define TTW_RMBF	0x0200		/* bZ[Wobt@̎M҂ */
#define TTW_CAL		0x0400		/* fǔĂяo҂ */
#define TTW_ACP		0x0800		/* fu̎t҂ */
#define TTW_RDV		0x1000		/* fȕI҂ */
#define TTW_MPF		0x2000		/* Œ蒷ubN̊l҂ */
#define TTW_MPL		0x4000		/* ϒubN̊l҂ */

#define TTEX_ENA	0x00		/* ^XN̗O */
#define TTEX_DIS	0x01		/* ^XNO֎~ */

#define TCYC_STP	0x00		/* nh삵ĂȂ */
#define TCYC_STA	0x01		/* nh삵Ă */

#define TALM_STP	0x00		/* A[nh삵ĂȂ */
#define TALM_STA	0x00		/* A[nh삵Ă */

#define TOVR_STP	0x00		/* vZbTԂݒ肳ĂȂ */
#define TOVR_STA	0x01		/* vZbTԂݒ肳Ă */

/* ̑̒萔 */
#define TSK_SELF	0			/* ^XNw */
#define TSK_NONE	0			/* Y^XN */

#define TPRI_SELF	0			/* ^XÑx[XDx̎w */
#define TPRI_INI	0			/* ^XN̋NDx̎w */


/* G[R[h */
#define E_SYS		(-5)		/* VXeG[ */
#define E_NOSPT		(-9)		/* T|[g@\ */
#define E_RSFN		(-10)		/* \@\R[h */
#define E_RSATR		(-11)		/* \񑮐 */
#define E_PAR		(-17)		/* p[^G[ */
#define E_ID		(-18)		/* sIDԍ */
#define E_CTX		(-25)		/* ReLXgG[ */
#define E_MACV		(-26)		/* ANZXᔽ */
#define E_OACV		(-27)		/* IuWFNgANZXᔽ */
#define E_ILUSE		(-28)		/* T[rXR[sgp */
#define E_NOMEM		(-33)		/* s */
#define E_NOID		(-34)		/* IDԍs */
#define E_OBJ		(-41)		/* IuWFNgԃG[ */
#define E_NOEXS		(-42)		/* IuWFNg */
#define E_QOVR		(-43)		/* L[COI[o[t[ */
#define E_RLWAI		(-49)		/* ҂Ԃ̋ */
#define E_TMOUT		(-50)		/* |[Os܂̓^CAEg */
#define E_DLT		(-51)		/* ҂IuWFNg̍폜 */
#define E_CLS		(-52)		/* ҂IuWFNg̏ԕω */
#define E_WBLK		(-57)		/* mubLOt */
#define E_BOVR		(-58)		/* obt@I[o[t[ */


/* ID͈̔(HOSƎ) */
#define TMIN_TSKID	1			/* ^XNIDԍ̍ŏl */
#define TMIN_SEMID	1			/* Z}tHIDԍ̍ŏl */
#define TMIN_FLGID	1			/* CxgtOIDԍ̍ŏl */
#define TMIN_DTQID	1			/* f[^L[IDԍ̍ŏl */
#define TMIN_MBXID	1			/* [{bNX^XNIDԍ̍ŏl */
#define TMIN_MBFID	1			/* bZ[Wobt@IDԍ̍ŏl */
#define TMIN_MPFID	1			/* Œ蒷v[IDԍ̍ŏl */
#define TMIN_CYCID	1			/* nhIDԍ̍ŏl */
#define TMIN_ALMID	1			/* A[nhIDԍ̍ŏl */
#define TMIN_ISRID	1			/* 荞݃T[rX[`IDԍ̍ŏl */



/* ------------------------------------ */
/*           }N`                 */
/* ------------------------------------ */


/* G[R[ho */
#define	MERCD(ercd)		((ER)((B)(ercd)))		/* G[R[h烁CG[R[ho */
#define	SERCD(ercd)		((ercd) >> 8)			/* G[R[hTuG[R[ho */



#endif /* __HOS_V4__itron_h__ */



/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
