/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ A[nh                           */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_alm_h__
#define __HOS_V4__knl_alm_h__



#include "knl_hos.h"
#include "knl_tim.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* ID͈̔ */
#define KERNEL_TMIN_ALMID	TMIN_ALMID			/* A[nhID̍ŏl */
#define KERNEL_TMAX_ALMID	(KERNEL_TMIN_ALMID + kernel_almcb_cnt - 1)
												/* A[nhID̍ől */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* A[nhRg[ubN(ROM) */
typedef struct t_kernel_almcb_rom
{
	ATR    almatr;		/* A[nh */
	VP_INT exinf;		/* A[nh̊g */
	FP     almhdr;		/* A[nh̋NԒn */
} T_KERNEL_ALMCB_ROM;

/* A[nhRg[ubN(RAM) */
typedef struct t_kernel_almcb_ram
{
	T_KERNEL_TIM timobj;		/* ^C}IuWFNgp */
	RELTIM       lefttim;		/* A[nĥɋN鎞܂ł̎ */
	const T_KERNEL_ALMCB_ROM *almcb_rom;	/* A[nhRg[ubNROMւ̃|C^ */
} T_KERNEL_ALMCB_RAM;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* A[nh */
extern       T_KERNEL_ALMCB_RAM *kernel_almcb_ram_tbl[];	/* A[nhRg[ubNe[u */
extern const INT kernel_almcb_cnt;							/* A[nhRg[ubN */

#define KERNEL_ALMID_TO_ALMCB_RAM(almid)	(kernel_almcb_ram_tbl[(almid) - KERNEL_TMIN_ALMID])
															/* A[nhIDALMCB RAMAhX擾 */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* A[nh */
void    kernel_ini_alm(void);								/* A[nh̏ */
void    kernel_alm_hdr(T_KERNEL_TIM *timobj, RELTIM tic);	/* A[nh̃^C}nh */
ER      sta_alm(ID almid, RELTIM almtim);					/* A[nh̓Jn */
ER      stp_alm(ID almid);									/* A[nh̓~ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_alm_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
