/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ nh                               */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_cyc_h__
#define __HOS_V4__knl_cyc_h__



#include "knl_hos.h"
#include "knl_tim.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* ID͈̔ */
#define KERNEL_TMIN_CYCID	TMIN_CYCID			/* nhID̍ŏl */
#define KERNEL_TMAX_CYCID	(KERNEL_TMIN_CYCID + kernel_cyccb_cnt - 1)
												/* nhID̍ől */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* nhRg[ubN(ROM) */
typedef struct t_kernel_cyccb_rom
{
	ATR    cycatr;		/* nh */
	VP_INT exinf;		/* nh̊g */
	FP     cychdr;		/* nh̋NԒn */
	RELTIM cyctim;		/* nh̋N */
/*	RELTIM cycphs;	*/	/* nh̋Nʑ(gp) */
} T_KERNEL_CYCCB_ROM, T_CCYC;

/* nhRg[ubN(RAM) */
typedef struct t_kernel_cyccb_ram
{
	T_KERNEL_TIM timobj;		/* ^C}IuWFNgp */
	RELTIM       lefttim;		/* nhɋN鎞܂ł̎ */
	const T_KERNEL_CYCCB_ROM *cyccb_rom;	/* nhRg[ubNROMւ̃|C^ */
} T_KERNEL_CYCCB_RAM;

/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* nh */
extern       T_KERNEL_CYCCB_RAM *kernel_cyccb_ram_tbl[];	/* nhRg[ubNe[u */
extern const INT kernel_cyccb_cnt;							/* nhRg[ubN */

#define KERNEL_CYCID_TO_CYCCB_RAM(cycid)	(kernel_cyccb_ram_tbl[(cycid) - KERNEL_TMIN_CYCID])
															/* nhIDCYCCB RAMAhX擾 */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* nh */
void    kernel_ini_cyc(void);								/* nh̏ */
void    kernel_cyc_hdr(T_KERNEL_TIM *timobj, RELTIM tic);	/* nh̃^C}nh */
ER      sta_cyc(ID cycid);									/* nh̓Jn */
ER      stp_cyc(ID cycid);									/* nh̓~ */
ER      cre_cyc(ID cycid, const T_CCYC *pk_ccyc);			/* nh̐ */
ER_ID   acre_cyc(const T_CCYC *pk_ccyc);					/* nh̐(IDԍt) */
ER      kernel_cre_cyc(ID cycid, const T_CCYC *pk_ccyc);	/* nh(J[l) */
ER      del_cyc(ID cycid);	/* nh̍폜 */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_cyc_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
