/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ f[^L[                               */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_dtq_h__
#define __HOS_V4__knl_dtq_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* ID͈̔ */
#define KERNEL_TMIN_DTQID	TMIN_DTQID			/* f[^L[ID̍ŏl */
#define KERNEL_TMAX_DTQID	(KERNEL_TMIN_DTQID + kernel_dtqcb_cnt - 1)
												/* f[^L[ID̍ől */



/* ------------------------------------------ */
/*                 }N`                 */
/* ------------------------------------------ */

/* ̈̃TCY */
#define TSZ_DTQ(dtqcnt)		((SIZE)((UINT)(dtqcnt) * sizeof(VP_INT)))



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* f[^L[ */
typedef struct t_cdtq
{
	ATR    dtqatr;		/* f[^L[ */
	UINT   dtqcnt;		/* f[^L[̗̈e(f[^̌) */
	VP     dtq;			/* f[^L[̈̐擪Ԓn */
} T_CDTQ;

/* f[^L[ */
typedef struct t_rdtq
{
	ID   stskid;		/* f[^L[̑M҂s̐擪̃^XNIDԍ */
	ID   rtskid;		/* f[^L[̎M҂s̐擪̃^XNIDԍ */
	UINT sdtqcnt;		/* f[^L[ɓĂf[^̐ */
} T_RDTQ;


/* f[^L[Rg[ubN(ROM) */
typedef struct t_kernel_dtqcb_rom
{
	ATR    dtqatr;		/* f[^L[ */
	UINT   dtqcnt;		/* f[^L[̗̈e(f[^̌) */
	VP_INT *dtq;		/* f[^L[̈̐擪Ԓn */
} T_KERNEL_DTQCB_ROM;

/* f[^L[Rg[ubN(RAM) */
typedef struct t_kernel_dtqcb_ram
{
	T_MKNL_QUE sndque;	/* f[^L[M҂^XNL[ */
	T_MKNL_QUE rcvque;	/* f[^L[M҂^XNL[ */
	UINT       head;	/* f[^̐擪 */
	UINT       datacnt;	/* f[^̌ */
	const T_KERNEL_DTQCB_ROM *dtqcb_rom;	/* f[^L[Rg[ubNROMւ̃|C^ */
} T_KERNEL_DTQCB_RAM;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* f[^L[Ǘ */
extern       T_KERNEL_DTQCB_RAM *kernel_dtqcb_ram_tbl[];	/* f[^L[Rg[ubNe[u(RAM) */
extern const INT kernel_dtqcb_cnt;							/* f[^L[Rg[ubN */

/* f[^L[Rg[ubNϊ}N */
#define KERNEL_DTQID_TO_DTQCB_RAM(dtqid)	(kernel_dtqcb_ram_tbl[(dtqid) - KERNEL_TMIN_DTQID])
															/* f[^L[IDDTQCB RAMAhX擾 */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */
#ifdef __cplusplus
extern "C" {
#endif

/* f[^L[ */
#define kernel_ini_dtq()									/* f[^L[̏ */
ER      cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq);			/* f[^L[̐ */
ER_ID   acre_dtq(const T_CDTQ *pk_cdtq);					/* f[^L[̐(IDԍt) */
ER      kernel_cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq);	/* f[^L[̐(J[l֐) */
ER      del_dtq(ID dtqid);									/* f[^L[̍폜 */
ER      snd_dtq(ID dtqid, VP_INT data);						/* f[^L[ւ̑M */
ER      psnd_dtq(ID dtqid, VP_INT data);					/* f[^L[ւ̑M(|[O) */
#define ipsnd_dtq	psnd_dtq								/* f[^L[ւ̑M(|[O ^XNReLXgp}N) */
ER      tsnd_dtq(ID dtqid, VP_INT data, TMO tmout);			/* f[^L[ւ̑M(^CAEg) */
ER      fsnd_dtq(ID dtqid, VP_INT data);					/* f[^L[ւ̋M */
#define ifsnd_dtq	fsnd_dtq								/* f[^L[ւ̋M(^XNReLXgp}N) */
ER      rcv_dtq(ID dtqid, VP_INT *p_data);					/* f[^L[̎M */
ER      prcv_dtq(ID dtqid, VP_INT *p_data);					/* f[^L[̎M(|[O) */
ER      trcv_dtq(ID dtqid, VP_INT *p_data, TMO tmout);		/* f[^L[̎M(^CAEg) */
ER      ref_dtq(ID dtqid, T_RDTQ *pk_rdtq);					/* f[^L[̏ԎQ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_dtq_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
