/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ CxgtO                             */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_flg_h__
#define __HOS_V4__knl_flg_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* ID͈̔ */
#define KERNEL_TMIN_FLGID	TMIN_FLGID			/* CxgtOID̍ŏl */
#define KERNEL_TMAX_FLGID	(KERNEL_TMIN_FLGID + kernel_flgcb_cnt - 1)
												/* CxgtOID̍ől */

/* rbgp^[̃rbg */
#define TBIT_FLGPTN			16					/* CxgtÕrbg */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* CxgtO */
typedef struct t_cflg
{
	ATR    flgatr;		/* CxgtO */
	FLGPTN iflgptn;		/* CxgtÕrbgp^[̏l */
} T_CFLG;

/* CxgtO */
typedef struct t_rflg
{
	ID     wtskid;		/* CxgtȎ҂s̐擪̃^XNIDԍ */
	FLGPTN flgptn;		/* CxgtǑ݂̃rbgp^[ */
} T_RFLG;


/* CxgtORg[ubN(ROM) */
typedef struct t_kernel_flgcb_rom
{
	ATR    flgatr;		/* CxgtO */
	FLGPTN iflgptn;		/* CxgtÕrbgp^[̏l */
} T_KERNEL_FLGCB_ROM;

/* CxgtORg[ubN(RAM) */
typedef struct t_kernel_flgcb_ram
{
	T_MKNL_QUE que;			/* CxgtO҂s */
	FLGPTN     flgptn;		/* CxgtÕrbgp^[ */
	const T_KERNEL_FLGCB_ROM* flgcb_rom;	/* CxgtORg[ubNROMւ̃|C^ */
} T_KERNEL_FLGCB_RAM;


/* ҂tO\ */
typedef struct t_kernel_flginf
{
	MODE   wfmode;		/* ҂[h */
	FLGPTN waiptn;		/* ҂rbgp^[ip^[ƌp) */
} T_KERNEL_FLGINF;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* CxgtOǗ */
extern       T_KERNEL_FLGCB_RAM *kernel_flgcb_ram_tbl[];	/* CxgtORg[ubNe[u(RAM) */
extern const INT kernel_flgcb_cnt;							/* CxgtORg[ubN */

#define KERNEL_FLGID_TO_FLGCB_RAM(flgid)	(kernel_flgcb_ram_tbl[(flgid) - KERNEL_TMIN_FLGID])
															/* CxgtOIDFLGCB RAMAhX擾 */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* CxgtO */
void    kernel_ini_flg(void);								/* CxgtȌ */
ER      cre_flg(ID flgid, const T_CFLG *pk_cflg);			/* CxgtO̐ */
ER_ID   acre_flg(const T_CFLG *pk_cflg);					/* CxgtO̐(IDԍt) */
ER      kernel_cre_flg(ID flgid, const T_CFLG *pk_cflg);	/* CxgtO̐(J[l֐) */
ER      del_flg(ID flgid);									/* CxgtO̍폜 */
ER      set_flg(ID flgid, FLGPTN setptn);					/* CxgtÕZbg */
#define iset_flg	set_flg									/* CxgtÕZbg(^XNReLXgp}N) */
ER      clr_flg(ID flgid, FLGPTN clrptn);					/* CxgtÕNA */
ER      wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/* CxgtO҂ */
ER      pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/* CxgtO҂(|[O) */
ER      twai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn, TMO tmout);
															/* CxgtO҂(^CAEg) */
ER      ref_flg(ID flgid, T_RFLG *pk_rflg);					/* CxgtȌԎQ */
BOOL    kernel_chk_flg(T_KERNEL_FLGCB_RAM *flgcb_ram, T_KERNEL_FLGINF *pk_flginf);
															/* tON𖞂Ă邩`FbN */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_flg_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
