/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ 荞݊Ǘ                               */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_int_h__
#define __HOS_V4__knl_int_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* 荞ݔԍ͈̔ */
#define KERNEL_TMIN_INTNO	(kernel_min_intno)	/* 荞ݔԍ̍ŏl */
#define KERNEL_TMAX_INTNO	(KERNEL_TMIN_INTNO + kernel_intcb_cnt - 1)
												/* 荞ݔԍ̍ől */

/* ID͈̔ */
#define KERNEL_TMIN_ISRID	TMIN_ISRID			/* 荞݃T[rX[`ID̍ŏl */
#define KERNEL_TMAX_ISRID	(KERNEL_TMIN_ISRID + kernel_isrcb_cnt - 1)
												/* 荞݃T[rX[`ID̍ől */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* 荞݊ǗRg[ubN */
typedef struct t_kernel_intcb
{
	VP_INT exinf;		/* 荞݃T[rX[`̊g */
	FP     isr;			/* 荞݃T[rX[`̋NԒn */
} T_KERNEL_INTCB;


/* 荞݃nh̒`p */
typedef struct t_dinh
{
	ATR inhatr;			/* 荞݃nh */
	FP  inthdr;			/* 荞݃nh̋NԒn */
} T_DINH;


/* 荞݃T[rX[`Rg[ubN */
typedef struct t_kernel_isrcb
{
	INTNO  intno;		/* 荞ݔԍ */
} T_KERNEL_ISRCB;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* 荞݊Ǘ */
extern T_KERNEL_INTCB  kernel_intcb_tbl[];	/* 荞݊ǗRg[ubNe[u */
extern const INT       kernel_intcb_cnt;	/* 荞ݔԍ */
extern const INTNO     kernel_min_intno;	/* 荞ݔԍŏl */

/* 荞݃T[rX[` */
extern T_KERNEL_ISRCB* kernel_isrcb_tbl[];	/* 荞݃T[rX[`Rg[ubNe[u */
extern const INT       kernel_isrcb_cnt;	/* 荞݃T[rX[`Rg[ubŇ */

/* 荞ݐϐ */
extern INT kernel_int_cnt;		/* 荞݃lXg */
extern VP  kernel_int_ssp;		/* 荞ݎX^bNޔ */

#define KERNEL_INTNO_TO_INTCB(intno)	(kernel_intcb_tbl[(intno) - KERNEL_TMIN_INTNO])


/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* 荞ݐ */
void    kernel_sta_int(void);						/* 荞݃ReLXgJn */
void    kernel_end_int(void);						/* 荞݃ReLXgI */

/* 荞݊Ǘ */
void    kernel_exe_int(INTNO intno);				/* 荞ݏs */
ER      dis_int(INTNO intno);						/* 荞݂̋֎~ */
ER      ena_int(INTNO intno);						/* 荞݂̋ */


/* 荞݃nh */
ER      def_inh(INTNO intno, T_DINH *pk_dinh);		/* 荞݃nh` */


/* 荞݃T[rX[` */
/*
ER      cre_isr();
ER      acre_isr();
*/

#ifdef __cplusplus
}
#endif



#endif	/*  __HOS_V4__knl_int_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
