/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ bZ[Wobt@                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_mbf_h__
#define __HOS_V4__knl_mbf_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* ID͈̔ */
#define KERNEL_TMIN_MBFID	TMIN_MBFID			/* bZ[Wobt@ID̍ŏl */
#define KERNEL_TMAX_MBFID	(KERNEL_TMIN_MBFID + kernel_mbfcb_cnt - 1)
												/* bZ[Wobt@ID̍ől */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* bZ[Wobt@ */
typedef struct t_cmbf
{
	ATR  mbfatr;		/* bZ[Wobt@ */
	UINT maxmsz;		/* bZ[W̍őTCY(oCg) */
	SIZE mbfsz;			/* bZ[Wobt@̈̃TCY(oCg) */
    VP   mbf;			/* bZ[Wobt@̈̐擪Ԓn */
} T_CMBF;

/* bZ[Wobt@ԏ */
typedef struct t_rmbf
{
	ID   stskid;		/* bZ[Wobt@̑M҂s̐擪̃^XNIDԍ */
	ID   rtskid;		/* bZ[Wobt@̎M҂s̐擪̃^XNIDԍ */
	UINT smsgcnt;		/* bZ[Wobt@ɓĂ郁bZ[W̐ */
	SIZE fmbfsz;		/* bZ[Wobt@̈̋󂫗̈̃TCY(oCgAŒ̊Ǘ̈) */
} T_RMBF;


/* bZ[Wobt@Rg[ubN(ROM) */
typedef struct t_kernel_mbfcb_rom
{
	ATR  mbfatr;		/* bZ[Wobt@ */
	UINT maxmsz;		/* bZ[W̍őTCY(oCg) */
	SIZE mbfsz;			/* bZ[Wobt@̈̃TCY(oCg) */
    VP   mbf;			/* bZ[Wobt@̈̐擪Ԓn */
} T_KERNEL_MBFCB_ROM;

/* bZ[Wobt@Rg[ubN(RAM) */
typedef struct t_kernel_mbfcb_ram
{
	T_MKNL_QUE sndque;	/* bZ[Wobt@M҂^XNL[ */
	T_MKNL_QUE rcvque;	/* bZ[Wobt@M҂^XNL[ */
	SIZE       head;	/* 擪bZ[Ẅʒu */
	SIZE       fmbfsz;	/* bZ[Wobt@̈̋󂫃TCY */
	UINT       smsgcnt;	/* bZ[Wobt@ɓĂ郁bZ[W̐ */
	const T_KERNEL_MBFCB_ROM *mbfcb_rom;	/* bZ[Wobt@Rg[ubNROMւ̃|C^ */
} T_KERNEL_MBFCB_RAM;

/* MbZ[Wf[^ */
typedef struct t_kernel_mbfdat
{
	UINT msgsz;			/* bZ[WTCY */
	VP   msg;			/* bZ[W̐擪Ԓn */
} T_KERNEL_MBFDAT;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* bZ[Wobt@Ǘ */
extern       T_KERNEL_MBFCB_RAM *kernel_mbfcb_ram_tbl[];	/* bZ[Wobt@Rg[ubNe[u(RAM) */
extern const INT kernel_mbfcb_cnt;							/* bZ[Wobt@Rg[ubN */

/* bZ[Wobt@Rg[ubNϊ}N */
#define KERNEL_MBFID_TO_MBFCB_RAM(mbfid)	(kernel_mbfcb_ram_tbl[(mbfid) - KERNEL_TMIN_MBFID])
															/* bZ[Wobt@IDMBFCB RAMAhX擾 */



/* ------------------------------------------ */
/*                 }N`                 */
/* ------------------------------------------ */

/* ̈̃TCY */
#define TSZ_MBF(msgcnt, msgsz)		((SIZE)((UINT)(msgcnt) * ((UINT)(msgsz) + 2) + 1))



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* bZ[Wobt@ */
void    kernel_ini_mbf(void);								/* bZ[Wobt@̏ */
ER      cre_mbf(ID mbfid, const T_CMBF *pk_cmbf);			/* bZ[Wobt@̐ */
ER_ID   acre_mbf(const T_CMBF *pk_cmbf);					/* bZ[Wobt@̐(IDԍt) */
ER      kernel_cre_mbf(ID mbfid, const T_CMBF *pk_cmbf);	/* bZ[Wobt@̐(J[l֐) */
ER      del_mbf(ID mbfid);									/* bZ[Wobt@̍폜 */
ER      snd_mbf(ID mbfid, VP msg, UINT msgsz);				/* bZ[Wobt@ւ̑M */
ER      psnd_mbf(ID mbfid, VP msg, UINT msgsz);				/* bZ[Wobt@ւ̑M(|[O) */
ER      tsnd_mbf(ID mbfid, VP msg, UINT msgsz, TMO tmout);	/* bZ[Wobt@ւ̑M(^CAEg) */
ER      kernel_snd_mbf(const T_KERNEL_MBFCB_ROM *mbfcb_rom,
			T_KERNEL_MBFCB_RAM *mbfcb_ram, VP msg, UINT msgsz);	/* bZ[Wobt@ւ̑M(J[l֐) */
ER_UINT rcv_mbf(ID mbfid, VP msg);							/* bZ[Wobt@̎M */
ER_UINT prcv_mbf(ID mbfid, VP msg);							/* bZ[Wobt@̎M(|[O) */
ER_UINT trcv_mbf(ID mbfid, VP msg,  TMO tmout);				/* bZ[Wobt@̎M(^CAEg) */
ER_UINT kernel_rcv_mbf(const T_KERNEL_MBFCB_ROM *mbfcb_rom,
			T_KERNEL_MBFCB_RAM *mbfcb_ram, VP msg);			/* bZ[Wobt@̎M(J[l֐) */
ER      ref_mbf(ID mbfid, T_RMBF *pk_rmbf);					/* bZ[Wobt@̏ԎQ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_mbf_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
