/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ [{bNX                             */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_mbx_h__
#define __HOS_V4__knl_mbx_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* ID͈̔ */
#define KERNEL_TMIN_MBXID	TMIN_MBXID			/* [{bNXID̍ŏl */
#define KERNEL_TMAX_MBXID	(KERNEL_TMIN_MBXID + kernel_mbxcb_cnt - 1)
												/* [{bNXID̍ől */


/* Dx͈̔ */
#define TMIN_MPRI			1					/* bZ[WDx̍ŏl */
#define TMAX_MPRI			32767				/* bZ[WDx̍ől */

/* Kvȃ̈̃TCY */
#define TSZ_MPRIHD(maxmpri)	(sizeof(T_MSG *) * ((maxmpri) - TMIN_MPRI + 1))
												/* DxʃL[wb_̃̈̃TCY */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* [{bNX̃bZ[Wwb_ */
typedef struct t_msg
{
	struct t_msg *next;		/* ̃bZ[Wւ̃|C^ */
} T_MSG;

/* [{bNX̗DxtbZ[Wwb_ */
typedef struct t_msg_pri
{
	T_MSG msg;				/* bZ[Wwb_ */
	PRI   msgpri;			/* bZ[WDx */
} T_MSG_PRI;


/* [{bNX */
typedef struct t_cmbx
{
	ATR   mbxatr;		/* [{bNX */
	PRI   maxmpri;		/* M郁bZ[W̗Dx̍ől */
	VP    mprihd;		/* Dxʂ̃bZ[WL[wb_̈̐擪Ԓn */
} T_CMBX;

/* [{bNX */
typedef struct t_rmbx
{
	ID    wtskid;		/* [{bNX̑҂s̐擪̃^XNIDԍ */
	T_MSG *pk_msg;		/* bZ[WL[̐擪̃bZ[WpPbg̐擪Ԓn */
} T_RMBX;


/* [{bNXRg[ubN(ROM) */
typedef struct t_kernel_mbxcb_rom
{
	ATR   mbxatr;		/* [{bNX */
	PRI   maxmpri;		/* M郁bZ[W̗Dx̍ől */
	T_MSG **mprihd;		/* Dxʂ̃bZ[WL[wb_̈̐擪Ԓn */
} T_KERNEL_MBXCB_ROM;

/* [{bNXRg[ubN(RAM) */
typedef struct t_kernel_mbxcb_ram
{
	T_MKNL_QUE que;							/* [{bNX҂^XNL[ */
	const T_KERNEL_MBXCB_ROM *mbxcb_rom;	/* [{bNXRg[ubNROMւ̃|C^ */
} T_KERNEL_MBXCB_RAM;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* [{bNXǗ */
extern       T_KERNEL_MBXCB_RAM *kernel_mbxcb_ram_tbl[];	/* [{bNXRg[ubNe[u(RAM) */
extern const INT kernel_mbxcb_cnt;							/* [{bNXRg[ubN */

#define KERNEL_MBXID_TO_MBXCB_RAM(mbxid)	(kernel_mbxcb_ram_tbl[(mbxid) - KERNEL_TMIN_MBXID])
															/* [{bNXIDMBXCB RAMAhX擾 */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* [{bNX */
#define kernel_ini_mbx()									/* [{bNX̏ */
ER      cre_mbx(ID semid, const T_CMBX *pk_cmbx);			/* Z}tH̐ */
ER_ID   acre_mbx(const T_CMBX *pk_cmbx);					/* Z}tH̐(IDԍt) */
ER      kernel_cre_mbx(ID mbxid, const T_CMBX *pk_cmbx);	/* Z}tH̐(J[l֐) */
ER      del_mbx(ID semid);									/* Z}tH̍폜 */
ER      snd_mbx(ID mbxid, T_MSG *pk_msg);					/* [{bNXւ̑M */
ER      rcv_mbx(ID mbxid, T_MSG **ppk_msg);					/* [{bNX̎M */
ER      prcv_mbx(ID mbxid, T_MSG **ppk_msg);				/* [{bNX̎M(|[O) */
ER      trcv_mbx(ID mbxid, T_MSG **ppk_msg, TMO tmout);		/* [{bNX̎M(^CAEg) */
ER      ref_mbx(ID mbxid, T_RMBX *pk_rmbx);					/* [{bNX̏ԎQ */

#ifdef __cplusplus
}
#endif



#endif	/*__HOS_V4__knl_mbx_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
