/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[l Ǘ                                                   */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_mem_h__
#define __HOS_V4__knl_mem_h__


#include "knl_hos.h"


/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* J[lǗ萔 */
#define MEMBLK_ALIGN	sizeof(VP)	/* ACg */

#define MEMBLK_USING	0x1234		/* gp */
#define MEMBLK_FREE		0xabcd		/* gp */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* J[lǗubN */
typedef struct t_kernel_mem_blk
{
	struct t_kernel_mem_blk* prev;		/* ÕubN */
	SIZE   size;						/* ubÑTCY */
	INT    flag;						/* gptO */
} T_KERNEL_MEM_BLK;

/* J[lǗubNTCY */
#define MEMBLKSIZE	((sizeof(T_KERNEL_MEM_BLK) + MEMBLK_ALIGN - 1) & ~(MEMBLK_ALIGN - 1))



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* J[lǗ */
extern T_KERNEL_MEM_BLK *kernel_mem_base;	/* J[lp擪ubÑAhX */
extern SIZE             kernel_mem_size;	/* J[lpTCY */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* VXeǗ */
void    kernel_ini_mem(void *p_base, SIZE size);	/* Ǘ */
VP      kernel_alc_mem(SIZE size);					/* ̊蓖 */
void    kernel_fre_mem(VP ptr);						/* ̉ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_mem_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
